/*
 * Decompiled with CFR 0.152.
 */
package net.darkmist.alib.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DbUtil {
    private static final Class<DbUtil> CLASS = DbUtil.class;
    private static final Logger logger = LoggerFactory.getLogger(CLASS);

    private DbUtil() {
    }

    public static void cleanup(PreparedStatement stmt) {
        if (stmt == null) {
            return;
        }
        try {
            stmt.clearParameters();
        }
        catch (SQLException e) {
            logger.warn("Exception clearing paramaters from prepared statement", (Throwable)e);
        }
        try {
            stmt.close();
        }
        catch (SQLException e) {
            logger.warn("Exception closing prepared statement", (Throwable)e);
        }
    }

    public static void cleanup(ResultSet rs) {
        if (rs == null) {
            return;
        }
        try {
            rs.close();
        }
        catch (SQLException e) {
            logger.warn("Exception closing result set", (Throwable)e);
        }
    }

    public static void cleanup(ResultSet rs, PreparedStatement stmt) {
        DbUtil.cleanup(rs);
        DbUtil.cleanup(stmt);
    }

    public static void cleanup(PreparedStatement stmt, ResultSet rs) {
        DbUtil.cleanup(rs, stmt);
    }
}

