/*
 * Decompiled with CFR 0.152.
 */
package net.darkmist.alib.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetIterator<E>
implements Iterator<E> {
    private static final Class<ResultSetIterator> CLASS = ResultSetIterator.class;
    private static final Logger logger = LoggerFactory.getLogger(CLASS);
    private ResultSet rs = null;
    private PreparedStatement stmt = null;
    private boolean more = false;
    private Row2Obj<E> converter;
    private boolean exclusive = false;

    public ResultSetIterator(ResultSet rs, Row2Obj<E> converter) throws SQLException {
        this.rs = rs;
        this.converter = converter;
        this.advance();
    }

    public ResultSetIterator(PreparedStatement stmt, Row2Obj<E> converter) throws SQLException {
        this.converter = converter;
        this.stmt = stmt;
        this.rs = stmt.executeQuery();
        this.advance();
    }

    public ResultSetIterator(PreparedStatement stmt, Row2Obj<E> converter, boolean exclusive) throws SQLException {
        this.converter = converter;
        this.stmt = stmt;
        this.rs = stmt.executeQuery();
        this.exclusive = exclusive;
        if (exclusive) {
            stmt.clearParameters();
        }
        this.advance();
    }

    protected ResultSetIterator(ResultSet rs, boolean exclusive) throws SQLException {
        this.rs = rs;
        this.exclusive = exclusive;
        this.advance();
    }

    protected ResultSetIterator(ResultSet rs) throws SQLException {
        this.rs = rs;
        this.advance();
    }

    protected ResultSetIterator(PreparedStatement stmt) throws SQLException {
        this.rs = stmt.executeQuery();
        this.stmt = stmt;
        this.advance();
    }

    protected ResultSetIterator(PreparedStatement stmt, boolean exclusive) throws SQLException {
        this.rs = stmt.executeQuery();
        this.stmt = stmt;
        this.exclusive = exclusive;
        if (exclusive) {
            stmt.clearParameters();
        }
        this.advance();
    }

    protected ResultSetIterator(Connection db, String sql) throws SQLException {
        this.stmt = db.prepareStatement(sql);
        this.exclusive = true;
        this.rs = this.stmt.executeQuery();
        this.stmt.clearParameters();
        this.advance();
    }

    protected void setConverter(Row2Obj<E> converter) throws SQLException {
        this.converter = converter;
    }

    private void advance() throws SQLException {
        if (this.rs.next()) {
            this.more = true;
        } else {
            this.more = false;
            this.close();
        }
    }

    public void close() throws SQLException {
        this.more = false;
        if (!this.exclusive) {
            return;
        }
        if (this.rs != null) {
            this.rs.close();
            this.rs = null;
        }
        if (this.stmt != null) {
            this.stmt.close();
            this.stmt = null;
        }
    }

    public ResultSetIterator<E> setExclusive(boolean exclusive) throws SQLException {
        this.exclusive = exclusive;
        if (this.stmt != null) {
            this.stmt.clearParameters();
        }
        if (exclusive && !this.more) {
            this.close();
        }
        return this;
    }

    public ResultSetIterator<E> setExclusive() throws SQLException {
        return this.setExclusive(true);
    }

    @Override
    public boolean hasNext() {
        return this.more;
    }

    @Override
    public E next() throws NoSuchElementException {
        if (!this.more) {
            throw new NoSuchElementException("No more rows to return");
        }
        try {
            E ret = this.converter.resultSetIteratorRow2Obj(this.rs);
            this.advance();
            return ret;
        }
        catch (NoSuchElementException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new IllegalStateException("SQLException which cannot be rethrown caught", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception which cannot be rethrown caught", e);
        }
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("remove is not implemented for ResultSetIterator");
    }

    public static interface Row2Obj<E> {
        public E resultSetIteratorRow2Obj(ResultSet var1) throws SQLException, Exception;
    }
}

