/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.dean.jraw.databind.DistinguishedStatusAdapter;
import net.dean.jraw.databind.EnvelopedListAdapterFactory;
import net.dean.jraw.databind.LiveWebSocketUpdateAdapterFactory;
import net.dean.jraw.databind.ModelAdapterFactory;
import net.dean.jraw.databind.RedditExceptionStubAdapterFactory;
import net.dean.jraw.databind.RedditModelAdapterFactory;
import net.dean.jraw.databind.RepliesAdapterFactory;
import net.dean.jraw.databind.SimpleFlairInfoListingAdapterFactory;
import net.dean.jraw.databind.SubmissionDataAdapterFactory;
import net.dean.jraw.databind.UnixDateAdapterFactory;
import net.dean.jraw.databind.VoteDirectionAdapter;
import net.dean.jraw.models.Account;
import net.dean.jraw.models.Comment;
import net.dean.jraw.models.DistinguishedStatus;
import net.dean.jraw.models.LiveThread;
import net.dean.jraw.models.LiveUpdate;
import net.dean.jraw.models.Message;
import net.dean.jraw.models.MoreChildren;
import net.dean.jraw.models.Submission;
import net.dean.jraw.models.Subreddit;
import net.dean.jraw.models.Trophy;
import net.dean.jraw.models.VoteDirection;
import net.dean.jraw.models.WikiPage;
import net.dean.jraw.models.internal.LabeledMultiDescription;
import net.dean.jraw.models.internal.TrophyList;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0006\b\u0000\u0010\u0007\u0018\u0001H\u0087\bJ'\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0006\b\u0000\u0010\u0007\u0018\u00012\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\tH\u0087\bJ-\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u000f\"\u00020\rH\u0007\u00a2\u0006\u0002\u0010\u0010J\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0012\u001a\u00020\rH\u0007J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0007J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lnet/dean/jraw/JrawUtils;", "", "()V", "moshi", "Lcom/squareup/moshi/Moshi;", "adapter", "Lcom/squareup/moshi/JsonAdapter;", "T", "annotationType", "Ljava/lang/Class;", "", "mapOf", "", "", "keysAndValues", "", "([Ljava/lang/String;)Ljava/util/Map;", "parseUrlEncoded", "str", "urlDecode", "urlEncode", "lib"})
public final class JrawUtils {
    @JvmField
    @NotNull
    public static final Moshi moshi;
    public static final JrawUtils INSTANCE;

    @JvmStatic
    private static final <T> JsonAdapter<T> adapter() {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        JsonAdapter jsonAdapter = moshi.adapter(Object.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"moshi.adapter(T::class.java)");
        return jsonAdapter;
    }

    @JvmStatic
    private static final <T> JsonAdapter<T> adapter(Class<? extends Annotation> annotationType) {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        JsonAdapter jsonAdapter = moshi.adapter((Type)((Object)Object.class), annotationType);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"moshi.adapter(T::class.java, annotationType)");
        return jsonAdapter;
    }

    @JvmStatic
    @NotNull
    public static final Map<String, String> parseUrlEncoded(@NotNull String str) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        if (StringsKt.isBlank((CharSequence)str)) {
            return MapsKt.emptyMap();
        }
        Map map = new HashMap();
        List pairs = StringsKt.split$default((CharSequence)str, (String[])new String[]{"&"}, (boolean)false, (int)0, (int)6, null);
        for (String pair : pairs) {
            List parts = StringsKt.split$default((CharSequence)pair, (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null);
            if (parts.size() != 2) {
                throw (Throwable)new IllegalArgumentException("Invalid number of elements, expected 2, got " + parts + " from input segment" + " '" + pair + '\'');
            }
            Map map2 = map;
            String string = JrawUtils.urlDecode((String)parts.get(0));
            String string2 = JrawUtils.urlDecode((String)parts.get(1));
            map2.put(string, string2);
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Map<String, String> mapOf(String ... keysAndValues) {
        Intrinsics.checkParameterIsNotNull((Object)keysAndValues, (String)"keysAndValues");
        String[] stringArray = keysAndValues;
        if (stringArray.length == 0) {
            return MapsKt.emptyMap();
        }
        if (keysAndValues.length % 2 == 1) {
            throw (Throwable)new IllegalArgumentException("Expecting an even amount of keys and values");
        }
        Map map = new HashMap();
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)ArraysKt.getIndices((Object[])keysAndValues)), (int)2);
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        int n4 = n;
        int n5 = n2;
        if (n3 > 0 ? n4 <= n5 : n4 >= n5) {
            while (true) {
                void i;
                Map map2 = map;
                String string = keysAndValues[i];
                String string2 = keysAndValues[i + true];
                map2.put(string, string2);
                if (i == n2) break;
                n = i + n3;
            }
        }
        return map;
    }

    @JvmStatic
    @NotNull
    public static final String urlEncode(@NotNull String str) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        String string = URLEncoder.encode(str, "UTF-8");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"URLEncoder.encode(str, \"UTF-8\")");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String urlDecode(@NotNull String str) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        String string = URLDecoder.decode(str, "UTF-8");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"URLDecoder.decode(str, \"UTF-8\")");
        return string;
    }

    private JrawUtils() {
    }

    static {
        JrawUtils jrawUtils;
        INSTANCE = jrawUtils = new JrawUtils();
        Moshi moshi = new Moshi.Builder().add((JsonAdapter.Factory)new UnixDateAdapterFactory()).add((JsonAdapter.Factory)new RepliesAdapterFactory()).add((JsonAdapter.Factory)new SubmissionDataAdapterFactory()).add((JsonAdapter.Factory)new SimpleFlairInfoListingAdapterFactory()).add((JsonAdapter.Factory)new EnvelopedListAdapterFactory()).add((JsonAdapter.Factory)new RedditModelAdapterFactory(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"t1", Comment.class), TuplesKt.to((Object)"t2", Account.class), TuplesKt.to((Object)"t3", Submission.class), TuplesKt.to((Object)"t5", Subreddit.class), TuplesKt.to((Object)"t6", Trophy.class), TuplesKt.to((Object)"TrophyList", TrophyList.class), TuplesKt.to((Object)"LabeledMultiDescription", LabeledMultiDescription.class), TuplesKt.to((Object)"LiveUpdateEvent", LiveThread.class), TuplesKt.to((Object)"LiveUpdate", LiveUpdate.class), TuplesKt.to((Object)"more", MoreChildren.class), TuplesKt.to((Object)"t4", Message.class), TuplesKt.to((Object)"wikipage", WikiPage.class)}))).add(ModelAdapterFactory.create()).add((Type)((Object)DistinguishedStatus.class), (JsonAdapter)new DistinguishedStatusAdapter()).add((Type)((Object)VoteDirection.class), (JsonAdapter)new VoteDirectionAdapter()).add((JsonAdapter.Factory)new RedditExceptionStubAdapterFactory()).add((JsonAdapter.Factory)new LiveWebSocketUpdateAdapterFactory()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)moshi, (String)"Moshi.Builder()\n        \u2026ctory())\n        .build()");
        JrawUtils.moshi = moshi;
    }
}

