/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import net.dean.jraw.ApiException;
import net.dean.jraw.Endpoint;
import net.dean.jraw.EndpointImplementation;
import net.dean.jraw.Extensions;
import net.dean.jraw.JrawUtils;
import net.dean.jraw.MethodType;
import net.dean.jraw.RedditClient;
import net.dean.jraw.RedditException;
import net.dean.jraw.databind.Enveloped;
import net.dean.jraw.http.HttpLogger;
import net.dean.jraw.http.HttpRequest;
import net.dean.jraw.http.HttpResponse;
import net.dean.jraw.http.NetworkAdapter;
import net.dean.jraw.http.NetworkException;
import net.dean.jraw.http.SimpleHttpLogger;
import net.dean.jraw.models.Comment;
import net.dean.jraw.models.Listing;
import net.dean.jraw.models.LiveThread;
import net.dean.jraw.models.OAuthData;
import net.dean.jraw.models.PublicContribution;
import net.dean.jraw.models.Submission;
import net.dean.jraw.models.Subreddit;
import net.dean.jraw.models.SubredditSearchQuery;
import net.dean.jraw.models.SubredditSearchResult;
import net.dean.jraw.models.SubredditSort;
import net.dean.jraw.models.internal.RedditExceptionStub;
import net.dean.jraw.models.internal.SubredditSearchResultContainer;
import net.dean.jraw.oauth.AuthManager;
import net.dean.jraw.oauth.AuthMethod;
import net.dean.jraw.oauth.Credentials;
import net.dean.jraw.oauth.NoopTokenStore;
import net.dean.jraw.oauth.TokenStore;
import net.dean.jraw.pagination.BarebonesPaginator;
import net.dean.jraw.pagination.DefaultPaginator;
import net.dean.jraw.pagination.SearchPaginator;
import net.dean.jraw.pagination.SubredditSearchPaginator;
import net.dean.jraw.ratelimit.LeakyBucketRateLimiter;
import net.dean.jraw.ratelimit.RateLimiter;
import net.dean.jraw.references.CommentReference;
import net.dean.jraw.references.LiveThreadReference;
import net.dean.jraw.references.OtherUserReference;
import net.dean.jraw.references.PublicContributionReference;
import net.dean.jraw.references.SelfUserReference;
import net.dean.jraw.references.SubmissionReference;
import net.dean.jraw.references.SubredditReference;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0098\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u0083\u00012\u00020\u0001:\u0002\u0083\u0001B5\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010:\u001a\u00020\u00182\u0006\u0010;\u001a\u00020<J\u000e\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u000bJ\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u00020C0AJ)\u0010D\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030F0E2\u0012\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0H\"\u00020\u000b\u00a2\u0006\u0002\u0010IJ\n\u0010J\u001a\u0004\u0018\u00010KH\u0007J%\u0010L\u001a\b\u0012\u0004\u0012\u00020M0E2\u0012\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0H\"\u00020\u000b\u00a2\u0006\u0002\u0010IJ\u000e\u0010N\u001a\u00020O2\u0006\u0010?\u001a\u00020\u000bJ%\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00010Q2\u0012\u0010R\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0H\"\u00020\u000b\u00a2\u0006\u0002\u0010SJ\u001c\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00010Q2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u000b0TH\u0007J\b\u0010U\u001a\u00020VH\u0007J\u000e\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020\u000bJ\b\u0010Z\u001a\u00020[H\u0007J+\u0010\\\u001a\u00020]2!\u0010^\u001a\u001d\u0012\u0013\u0012\u00110`\u00a2\u0006\f\ba\u0012\b\bb\u0012\u0004\b\b(c\u0012\u0004\u0012\u00020`0_H\u0007J\u0010\u0010\\\u001a\u00020]2\u0006\u0010d\u001a\u00020eH\u0007J\u001a\u0010\\\u001a\u00020]2\u0006\u0010d\u001a\u00020e2\b\b\u0002\u0010f\u001a\u000205H\u0003J\u0006\u0010g\u001a\u00020`J\u0006\u0010h\u001a\u00020\u000bJ\u0006\u0010i\u001a\u00020jJ\b\u0010k\u001a\u00020lH\u0007J\u0014\u0010m\u001a\b\u0012\u0004\u0012\u00020n0T2\u0006\u0010o\u001a\u00020\u000bJ\u0016\u0010m\u001a\b\u0012\u0004\u0012\u00020n0T2\u0006\u0010o\u001a\u00020pH\u0007J\u000e\u0010q\u001a\u00020r2\u0006\u0010?\u001a\u00020\u000bJ\u000e\u0010s\u001a\u00020[2\u0006\u0010b\u001a\u00020\u000bJ/\u0010G\u001a\u00020[2\u0006\u0010t\u001a\u00020\u000b2\u0006\u0010u\u001a\u00020\u000b2\u0012\u0010v\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0H\"\u00020\u000b\u00a2\u0006\u0002\u0010wJ\b\u0010x\u001a\u00020\u000bH\u0016J\u000e\u0010y\u001a\u00020z2\u0006\u0010b\u001a\u00020\u000bJ\u0016\u0010{\u001a\b\u0012\u0004\u0012\u00020|0E2\u0006\u0010}\u001a\u00020\u000bH\u0007J\u0019\u0010~\u001a\u00020\u007f2\u0007\u0010\u0080\u0001\u001a\u00020\u000b2\b\u0010\u0081\u0001\u001a\u00030\u0082\u0001R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001a\"\u0004\b$\u0010\u001cR\u001a\u0010%\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001a\"\u0004\b'\u0010\u001cR\u001a\u0010(\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001a\u00104\u001a\u000205X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109\u00a8\u0006\u0084\u0001"}, d2={"Lnet/dean/jraw/RedditClient;", "", "http", "Lnet/dean/jraw/http/NetworkAdapter;", "initialOAuthData", "Lnet/dean/jraw/models/OAuthData;", "creds", "Lnet/dean/jraw/oauth/Credentials;", "tokenStore", "Lnet/dean/jraw/oauth/TokenStore;", "overrideUsername", "", "(Lnet/dean/jraw/http/NetworkAdapter;Lnet/dean/jraw/models/OAuthData;Lnet/dean/jraw/oauth/Credentials;Lnet/dean/jraw/oauth/TokenStore;Ljava/lang/String;)V", "authManager", "Lnet/dean/jraw/oauth/AuthManager;", "getAuthManager", "()Lnet/dean/jraw/oauth/AuthManager;", "setAuthManager", "(Lnet/dean/jraw/oauth/AuthManager;)V", "authMethod", "Lnet/dean/jraw/oauth/AuthMethod;", "getAuthMethod", "()Lnet/dean/jraw/oauth/AuthMethod;", "autoRenew", "", "getAutoRenew", "()Z", "setAutoRenew", "(Z)V", "forceRenew", "getForceRenew$lib", "setForceRenew$lib", "getHttp", "()Lnet/dean/jraw/http/NetworkAdapter;", "logHttp", "getLogHttp", "setLogHttp", "loggedOut", "getLoggedOut$lib", "setLoggedOut$lib", "logger", "Lnet/dean/jraw/http/HttpLogger;", "getLogger", "()Lnet/dean/jraw/http/HttpLogger;", "setLogger", "(Lnet/dean/jraw/http/HttpLogger;)V", "rateLimiter", "Lnet/dean/jraw/ratelimit/RateLimiter;", "getRateLimiter", "()Lnet/dean/jraw/ratelimit/RateLimiter;", "setRateLimiter", "(Lnet/dean/jraw/ratelimit/RateLimiter;)V", "retryLimit", "", "getRetryLimit", "()I", "setRetryLimit", "(I)V", "canAccess", "e", "Lnet/dean/jraw/Endpoint;", "comment", "Lnet/dean/jraw/references/CommentReference;", "id", "frontPage", "Lnet/dean/jraw/pagination/DefaultPaginator$Builder;", "Lnet/dean/jraw/models/Submission;", "Lnet/dean/jraw/models/SubredditSort;", "gildedContributions", "Lnet/dean/jraw/pagination/BarebonesPaginator$Builder;", "Lnet/dean/jraw/models/PublicContribution;", "subreddits", "", "([Ljava/lang/String;)Lnet/dean/jraw/pagination/BarebonesPaginator$Builder;", "happeningNow", "Lnet/dean/jraw/models/LiveThread;", "latestComments", "Lnet/dean/jraw/models/Comment;", "liveThread", "Lnet/dean/jraw/references/LiveThreadReference;", "lookup", "Lnet/dean/jraw/models/Listing;", "fullNames", "([Ljava/lang/String;)Lnet/dean/jraw/models/Listing;", "", "me", "Lnet/dean/jraw/references/SelfUserReference;", "publicContribution", "Lnet/dean/jraw/references/PublicContributionReference;", "fullname", "randomSubreddit", "Lnet/dean/jraw/references/SubredditReference;", "request", "Lnet/dean/jraw/http/HttpResponse;", "configure", "Lkotlin/Function1;", "Lnet/dean/jraw/http/HttpRequest$Builder;", "Lkotlin/ParameterName;", "name", "stub", "r", "Lnet/dean/jraw/http/HttpRequest;", "retryCount", "requestStub", "requireAuthenticatedUser", "search", "Lnet/dean/jraw/pagination/SearchPaginator$Builder;", "searchSubreddits", "Lnet/dean/jraw/pagination/SubredditSearchPaginator$Builder;", "searchSubredditsByName", "Lnet/dean/jraw/models/SubredditSearchResult;", "query", "Lnet/dean/jraw/models/SubredditSearchQuery;", "submission", "Lnet/dean/jraw/references/SubmissionReference;", "subreddit", "first", "second", "others", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lnet/dean/jraw/references/SubredditReference;", "toString", "user", "Lnet/dean/jraw/references/OtherUserReference;", "userSubreddits", "Lnet/dean/jraw/models/Subreddit;", "where", "websocket", "Lokhttp3/WebSocket;", "url", "listener", "Lokhttp3/WebSocketListener;", "Companion", "lib"})
public final class RedditClient {
    @NotNull
    private HttpLogger logger;
    private boolean logHttp;
    private int retryLimit;
    @NotNull
    private RateLimiter rateLimiter;
    private boolean autoRenew;
    private boolean forceRenew;
    @NotNull
    private AuthManager authManager;
    @NotNull
    private final AuthMethod authMethod;
    private boolean loggedOut;
    @NotNull
    private final NetworkAdapter http;
    public static final long RATE_LIMIT = 1L;
    private static final long BURST_LIMIT = 5L;
    private static final int DEFAULT_RETRY_LIMIT = 5;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final HttpLogger getLogger() {
        return this.logger;
    }

    public final void setLogger(@NotNull HttpLogger httpLogger) {
        Intrinsics.checkParameterIsNotNull((Object)httpLogger, (String)"<set-?>");
        this.logger = httpLogger;
    }

    public final boolean getLogHttp() {
        return this.logHttp;
    }

    public final void setLogHttp(boolean bl) {
        this.logHttp = bl;
    }

    public final int getRetryLimit() {
        return this.retryLimit;
    }

    public final void setRetryLimit(int n) {
        this.retryLimit = n;
    }

    @NotNull
    public final RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public final void setRateLimiter(@NotNull RateLimiter rateLimiter) {
        Intrinsics.checkParameterIsNotNull((Object)rateLimiter, (String)"<set-?>");
        this.rateLimiter = rateLimiter;
    }

    public final boolean getAutoRenew() {
        return this.autoRenew;
    }

    public final void setAutoRenew(boolean bl) {
        this.autoRenew = bl;
    }

    public final boolean getForceRenew$lib() {
        return this.forceRenew;
    }

    public final void setForceRenew$lib(boolean bl) {
        this.forceRenew = bl;
    }

    @NotNull
    public final AuthManager getAuthManager() {
        return this.authManager;
    }

    public final void setAuthManager(@NotNull AuthManager authManager) {
        Intrinsics.checkParameterIsNotNull((Object)authManager, (String)"<set-?>");
        this.authManager = authManager;
    }

    @NotNull
    public final AuthMethod getAuthMethod() {
        return this.authMethod;
    }

    public final boolean getLoggedOut$lib() {
        return this.loggedOut;
    }

    public final void setLoggedOut$lib(boolean bl) {
        this.loggedOut = bl;
    }

    @NotNull
    public final HttpRequest.Builder requestStub() {
        return new HttpRequest.Builder().secure(true).host("oauth.reddit.com").header("Authorization", "bearer " + this.authManager.getAccessToken());
    }

    private final HttpResponse request(HttpRequest r, int retryCount) throws NetworkException {
        MediaType type;
        HttpResponse httpResponse;
        if (this.loggedOut) {
            throw (Throwable)new IllegalStateException("This client is logged out and should not be used anymore");
        }
        HttpRequest req = r;
        if (this.forceRenew || this.autoRenew && this.authManager.needsRenewing() && this.authManager.canRenew()) {
            this.authManager.renew();
            this.forceRenew = false;
            req = req.newBuilder().header("Authorization", "bearer " + this.authManager.getAccessToken()).build();
        }
        if (req.getRawJson()) {
            HttpUrl httpUrl = HttpUrl.parse((String)req.getUrl());
            if (httpUrl == null) {
                Intrinsics.throwNpe();
            }
            HttpUrl url = httpUrl;
            HttpUrl.Builder newUrl = url.newBuilder();
            if (Intrinsics.areEqual((Object)url.queryParameterValues("raw_json"), (Object)CollectionsKt.listOf((Object)"1")) ^ true) {
                newUrl = newUrl.removeAllQueryParameters("raw_json").addQueryParameter("raw_json", "1");
            }
            HttpRequest.Builder builder = req.newBuilder();
            HttpUrl httpUrl2 = newUrl.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl2, (String)"newUrl.build()");
            req = builder.url(httpUrl2).build();
        }
        if (retryCount == 0) {
            RateLimiter.DefaultImpls.acquire$default(this.rateLimiter, 0L, 1, null);
        }
        if (this.logHttp) {
            HttpLogger.Tag tag = HttpLogger.DefaultImpls.request$default(this.logger, req, null, 2, null);
            HttpResponse res2 = this.http.execute(req);
            this.logger.response(tag, res2);
            httpResponse = res2;
        } else {
            httpResponse = this.http.execute(req);
        }
        HttpResponse res3 = httpResponse;
        int tag = res3.getCode();
        if (500 <= tag && 599 >= tag && retryCount < this.retryLimit) {
            return this.request(req, retryCount + 1);
        }
        ResponseBody responseBody = res3.getRaw().body();
        Object object = type = responseBody != null ? responseBody.contentType() : null;
        if (type != null && Intrinsics.areEqual((Object)type.type(), (Object)"application") && Intrinsics.areEqual((Object)type.subtype(), (Object)"json")) {
            Object ex;
            RedditExceptionStub stub;
            JsonAdapter jsonAdapter = JrawUtils.moshi.adapter(RedditExceptionStub.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"moshi.adapter(T::class.java)");
            JsonAdapter adapter = jsonAdapter.lenient();
            RedditExceptionStub redditExceptionStub = stub = Intrinsics.areEqual((Object)res3.getBody(), (Object)"") ? null : (RedditExceptionStub)adapter.fromJson(res3.getBody());
            if (stub != null && (ex = stub.create(new NetworkException(res3))) != null) {
                throw (Throwable)ex;
            }
        }
        if (!res3.getSuccessful()) {
            throw (Throwable)new NetworkException(res3);
        }
        return res3;
    }

    static /* bridge */ /* synthetic */ HttpResponse request$default(RedditClient redditClient, HttpRequest httpRequest, int n, int n2, Object object) throws NetworkException {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return redditClient.request(httpRequest, n);
    }

    @NotNull
    public final WebSocket websocket(@NotNull String url, @NotNull WebSocketListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        return this.http.connect(url, listener);
    }

    @NotNull
    public final HttpResponse request(@NotNull HttpRequest r) throws NetworkException, RedditException {
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        return this.request(r, 0);
    }

    @NotNull
    public final HttpResponse request(@NotNull Function1<? super HttpRequest.Builder, HttpRequest.Builder> configure2) throws NetworkException, RedditException {
        Intrinsics.checkParameterIsNotNull(configure2, (String)"configure");
        return this.request(((HttpRequest.Builder)configure2.invoke((Object)this.requestStub())).build());
    }

    @NotNull
    public final SelfUserReference me() throws IllegalStateException {
        return new SelfUserReference(this);
    }

    @NotNull
    public final OtherUserReference user(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return new OtherUserReference(this, name);
    }

    /*
     * WARNING - void declaration
     */
    @EndpointImplementation(type=MethodType.NON_BLOCKING_CALL, endpoints={Endpoint.GET_USERS_WHERE})
    @NotNull
    public final BarebonesPaginator.Builder<Subreddit> userSubreddits(@NotNull String where) {
        void reddit$iv;
        Intrinsics.checkParameterIsNotNull((Object)where, (String)"where");
        BarebonesPaginator.Builder.Companion companion = BarebonesPaginator.Builder.Companion;
        RedditClient redditClient = this;
        String baseUrl$iv = "/users/" + JrawUtils.urlEncode(where);
        return new BarebonesPaginator.Builder<Subreddit>((RedditClient)reddit$iv, baseUrl$iv, Subreddit.class);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DefaultPaginator.Builder<Submission, SubredditSort> frontPage() {
        void baseUrl$iv;
        void reddit$iv;
        DefaultPaginator.Builder.Companion companion = DefaultPaginator.Builder.Companion;
        RedditClient redditClient = this;
        String string = "";
        boolean sortingAlsoInPath$iv = true;
        return new DefaultPaginator.Builder<Submission, SubredditSort>((RedditClient)reddit$iv, (String)baseUrl$iv, sortingAlsoInPath$iv, Submission.class);
    }

    @NotNull
    public final SearchPaginator.Builder search() {
        return SearchPaginator.Companion.everywhere(this);
    }

    @EndpointImplementation(endpoints={Endpoint.GET_SUBREDDITS_SEARCH})
    @NotNull
    public final SubredditSearchPaginator.Builder searchSubreddits() {
        return new SubredditSearchPaginator.Builder(this, null, 2, null);
    }

    @NotNull
    public final List<SubredditSearchResult> searchSubredditsByName(@NotNull String query) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        return this.searchSubredditsByName(new SubredditSearchQuery(query, null, null, null, 14, null));
    }

    @EndpointImplementation(endpoints={Endpoint.POST_SEARCH_SUBREDDITS})
    @NotNull
    public final List<SubredditSearchResult> searchSubredditsByName(@NotNull SubredditSearchQuery query) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        HttpResponse this_$iv = this.request((Function1<? super HttpRequest.Builder, HttpRequest.Builder>)((Function1)new Function1<HttpRequest.Builder, HttpRequest.Builder>(query){
            final /* synthetic */ SubredditSearchQuery $query;

            @NotNull
            public final HttpRequest.Builder invoke(@NotNull HttpRequest.Builder it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Pair[] pairArray = new Pair[4];
                pairArray[0] = TuplesKt.to((Object)"query", (Object)this.$query.getQuery());
                Boolean bl = this.$query.getExact();
                pairArray[1] = TuplesKt.to((Object)"exact", (Object)(bl != null ? String.valueOf(bl) : null));
                Boolean bl2 = this.$query.getIncludeNsfw();
                pairArray[2] = TuplesKt.to((Object)"include_over_18", (Object)(bl2 != null ? String.valueOf(bl2) : null));
                Boolean bl3 = this.$query.getIncludeUnadvertisable();
                pairArray[3] = TuplesKt.to((Object)"include_unadvertisable", (Object)(bl3 != null ? String.valueOf(bl3) : null));
                return it.endpoint(Endpoint.POST_SEARCH_SUBREDDITS, new String[0]).post(Extensions.filterValuesNotNull(MapsKt.mapOf((Pair[])pairArray)));
            }
            {
                this.$query = subredditSearchQuery;
                super(1);
            }
        }));
        HttpResponse httpResponse = this_$iv;
        JsonAdapter jsonAdapter = JrawUtils.moshi.adapter(SubredditSearchResultContainer.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"moshi.adapter(T::class.java)");
        JsonAdapter jsonAdapter2 = jsonAdapter;
        SubredditSearchResultContainer container2 = (SubredditSearchResultContainer)httpResponse.deserializeWith(jsonAdapter2);
        List<SubredditSearchResult> list = container2.getSubreddits();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"container.subreddits");
        return list;
    }

    @NotNull
    public final SubredditReference subreddit(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return new SubredditReference(this, name);
    }

    @NotNull
    public final SubredditReference subreddits(@NotNull String first, @NotNull String second, String ... others) {
        Intrinsics.checkParameterIsNotNull((Object)first, (String)"first");
        Intrinsics.checkParameterIsNotNull((Object)second, (String)"second");
        Intrinsics.checkParameterIsNotNull((Object)others, (String)"others");
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        spreadBuilder.add((Object)first);
        spreadBuilder.add((Object)second);
        spreadBuilder.addSpread((Object)others);
        return new SubredditReference(this, ArraysKt.joinToString$default((Object[])((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()])), (CharSequence)"+", null, null, (int)0, null, null, (int)62, null));
    }

    public final boolean canAccess(@NotNull Endpoint e) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)e), (String)"e");
        Object object = this.authManager.getCurrent();
        if (object == null || (object = ((OAuthData)object).getScopes()) == null) {
            return false;
        }
        Object scopes = object;
        if (scopes.contains("*")) {
            return true;
        }
        return scopes.contains(e.getScope());
    }

    @EndpointImplementation(type=MethodType.NON_BLOCKING_CALL, endpoints={Endpoint.GET_RANDOM})
    @NotNull
    public final SubredditReference randomSubreddit() {
        return this.subreddit("random");
    }

    @NotNull
    public final PublicContributionReference publicContribution(@NotNull String fullname) {
        PublicContributionReference publicContributionReference;
        Intrinsics.checkParameterIsNotNull((Object)fullname, (String)"fullname");
        List parts = StringsKt.split$default((CharSequence)fullname, (char[])new char[]{'_'}, (boolean)false, (int)0, (int)6, null);
        if (parts.size() != 2) {
            throw (Throwable)new IllegalArgumentException("Fullname doesn't match the pattern KIND_ID");
        }
        switch ((String)parts.get(0)) {
            case "t1": {
                publicContributionReference = this.comment((String)parts.get(1));
                break;
            }
            case "t3": {
                publicContributionReference = this.submission((String)parts.get(1));
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Provided kind '" + (String)parts.get(0) + "' is not a public contribution");
            }
        }
        return publicContributionReference;
    }

    @NotNull
    public final SubmissionReference submission(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return new SubmissionReference(this, id);
    }

    @NotNull
    public final CommentReference comment(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return new CommentReference(this, id);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BarebonesPaginator.Builder<Comment> latestComments(String ... subreddits) {
        void reddit$iv;
        Intrinsics.checkParameterIsNotNull((Object)subreddits, (String)"subreddits");
        Object object = subreddits;
        String prefix = ((String[])object).length == 0 ? "" : "/r/" + ArraysKt.joinToString$default((Object[])subreddits, (CharSequence)"+", null, null, (int)0, null, null, (int)62, null);
        object = BarebonesPaginator.Builder.Companion;
        RedditClient redditClient = this;
        String baseUrl$iv = "" + prefix + "/comments";
        return new BarebonesPaginator.Builder<Comment>((RedditClient)reddit$iv, baseUrl$iv, Comment.class);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BarebonesPaginator.Builder<PublicContribution<?>> gildedContributions(String ... subreddits) {
        void reddit$iv;
        Intrinsics.checkParameterIsNotNull((Object)subreddits, (String)"subreddits");
        Object object = subreddits;
        String prefix = ((String[])object).length == 0 ? "" : "/r/" + ArraysKt.joinToString$default((Object[])subreddits, (CharSequence)"+", null, null, (int)0, null, null, (int)62, null);
        object = BarebonesPaginator.Builder.Companion;
        RedditClient redditClient = this;
        String baseUrl$iv = "" + prefix + "/gilded";
        return new BarebonesPaginator.Builder((RedditClient)reddit$iv, baseUrl$iv, PublicContribution.class);
    }

    @NotNull
    public final String requireAuthenticatedUser() {
        if (this.authMethod.isUserless()) {
            throw (Throwable)new IllegalStateException("Expected the RedditClient to have an active user, was authenticated with " + (Object)((Object)this.authMethod));
        }
        String string = this.authManager.getCurrentUsername$lib();
        if (string == null) {
            throw (Throwable)new IllegalStateException("Expected an authenticated user");
        }
        return string;
    }

    @NotNull
    public final Listing<Object> lookup(String ... fullNames) {
        Intrinsics.checkParameterIsNotNull((Object)fullNames, (String)"fullNames");
        return this.lookup(CollectionsKt.listOf((Object[])Arrays.copyOf(fullNames, fullNames.length)));
    }

    @EndpointImplementation(endpoints={Endpoint.GET_INFO})
    @NotNull
    public final Listing<Object> lookup(@NotNull List<String> fullNames) {
        Intrinsics.checkParameterIsNotNull(fullNames, (String)"fullNames");
        if (fullNames.isEmpty()) {
            Listing<Object> listing = Listing.empty();
            Intrinsics.checkExpressionValueIsNotNull(listing, (String)"Listing.empty()");
            return listing;
        }
        ParameterizedType type = Types.newParameterizedType((Type)((Type)((Object)Listing.class)), (Type[])new Type[]{(Type)((Object)Object.class)});
        JsonAdapter adapter = JrawUtils.moshi.adapter((Type)type, Enveloped.class);
        HttpResponse httpResponse = this.request((Function1<? super HttpRequest.Builder, HttpRequest.Builder>)((Function1)new Function1<HttpRequest.Builder, HttpRequest.Builder>(fullNames){
            final /* synthetic */ List $fullNames;

            @NotNull
            public final HttpRequest.Builder invoke(@NotNull HttpRequest.Builder it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.endpoint(Endpoint.GET_INFO, new String[]{null}).query(MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)CollectionsKt.joinToString$default((Iterable)this.$fullNames, (CharSequence)",", null, null, (int)0, null, null, (int)62, null))));
            }
            {
                this.$fullNames = list;
                super(1);
            }
        }));
        JsonAdapter jsonAdapter = adapter;
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"adapter");
        Object t = httpResponse.deserializeWith(jsonAdapter);
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"request {\n            it\u2026.deserializeWith(adapter)");
        return (Listing)t;
    }

    @NotNull
    public final LiveThreadReference liveThread(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return new LiveThreadReference(this, id);
    }

    @EndpointImplementation(endpoints={Endpoint.GET_LIVE_HAPPENING_NOW})
    @Nullable
    public final LiveThread happeningNow() {
        HttpResponse this_$iv;
        HttpResponse res2 = this.request((Function1<? super HttpRequest.Builder, HttpRequest.Builder>)((Function1)happeningNow.res.1.INSTANCE));
        if (res2.getCode() == 204) {
            return null;
        }
        HttpResponse httpResponse = this_$iv = res2;
        JsonAdapter jsonAdapter = JrawUtils.moshi.adapter(LiveThread.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"moshi.adapter(T::class.java)");
        JsonAdapter jsonAdapter2 = jsonAdapter;
        return (LiveThread)httpResponse.deserializeWith(jsonAdapter2);
    }

    @NotNull
    public String toString() {
        return "RedditClient(username=" + this.authManager.currentUsername() + ')';
    }

    @NotNull
    public final NetworkAdapter getHttp() {
        return this.http;
    }

    public RedditClient(@NotNull NetworkAdapter http, @NotNull OAuthData initialOAuthData, @NotNull Credentials creds, @NotNull TokenStore tokenStore, @Nullable String overrideUsername) {
        Intrinsics.checkParameterIsNotNull((Object)http, (String)"http");
        Intrinsics.checkParameterIsNotNull((Object)initialOAuthData, (String)"initialOAuthData");
        Intrinsics.checkParameterIsNotNull((Object)creds, (String)"creds");
        Intrinsics.checkParameterIsNotNull((Object)tokenStore, (String)"tokenStore");
        this.http = http;
        this.logger = new SimpleHttpLogger(0, null, 3, null);
        this.logHttp = true;
        this.retryLimit = 5;
        this.rateLimiter = new LeakyBucketRateLimiter(5L, 1L, TimeUnit.SECONDS);
        this.autoRenew = true;
        this.authManager = new AuthManager(this.http, creds);
        this.authMethod = creds.getAuthMethod();
        AuthManager authManager = this.authManager;
        String string = overrideUsername;
        if (string == null) {
            String string2;
            AuthManager authManager2 = authManager;
            try {
                Map me;
                Map this_$iv;
                HttpResponse httpResponse = this.request(new HttpRequest.Builder().url("https://oauth.reddit.com/api/v1/me").header("Authorization", "bearer " + initialOAuthData.getAccessToken()).build());
                AuthManager authManager3 = authManager2;
                String string3 = this_$iv;
                JsonAdapter jsonAdapter = JrawUtils.moshi.adapter(Map.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"moshi.adapter(T::class.java)");
                JsonAdapter jsonAdapter2 = jsonAdapter;
                Object object = ((HttpResponse)((Object)string3)).deserializeWith(jsonAdapter2);
                this_$iv = me = (Map)object;
                string3 = "name";
                object = this_$iv.get(string3);
                authManager = authManager3;
                Object object2 = object;
                if (!(object2 instanceof String)) {
                    object2 = null;
                }
                String string4 = (String)object2;
                if (string4 == null) {
                    throw (Throwable)new IllegalArgumentException("Expected a name");
                }
                string2 = string4;
            }
            catch (ApiException this_$iv) {
                authManager = authManager2;
                string2 = null;
            }
            string = string2;
        }
        authManager.setCurrentUsername$lib(string);
        this.authManager.setTokenStore(tokenStore);
        this.authManager.update$lib(initialOAuthData);
    }

    public /* synthetic */ RedditClient(NetworkAdapter networkAdapter, OAuthData oAuthData, Credentials credentials, TokenStore tokenStore, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            tokenStore = new NoopTokenStore();
        }
        if ((n & 0x10) != 0) {
            string = null;
        }
        this(networkAdapter, oAuthData, credentials, tokenStore, string);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lnet/dean/jraw/RedditClient$Companion;", "", "()V", "BURST_LIMIT", "", "DEFAULT_RETRY_LIMIT", "", "RATE_LIMIT", "lib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

