/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.databind;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.dean.jraw.databind.UnixTime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\r"}, d2={"Lnet/dean/jraw/databind/UnixDateAdapterFactory;", "Lcom/squareup/moshi/JsonAdapter$Factory;", "()V", "create", "Lcom/squareup/moshi/JsonAdapter;", "type", "Ljava/lang/reflect/Type;", "annotations", "", "", "moshi", "Lcom/squareup/moshi/Moshi;", "Adapter", "lib"})
public final class UnixDateAdapterFactory
implements JsonAdapter.Factory {
    @Nullable
    public JsonAdapter<?> create(@NotNull Type type, @NotNull Set<? extends Annotation> annotations, @Nullable Moshi moshi) {
        Object element$iv2;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
            if (Types.nextAnnotations(annotations, UnixTime.class) == null) {
                return null;
            }
            Iterable $receiver$iv = annotations;
            for (Object element$iv2 : $receiver$iv) {
                Annotation it = (Annotation)element$iv2;
                if (!(it instanceof UnixTime)) continue;
                break block3;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object t = element$iv2;
        if (t == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.dean.jraw.databind.UnixTime");
        }
        TimeUnit precision = ((UnixTime)t).precision();
        return new Adapter(precision);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lnet/dean/jraw/databind/UnixDateAdapterFactory$Adapter;", "Lcom/squareup/moshi/JsonAdapter;", "Ljava/util/Date;", "precision", "Ljava/util/concurrent/TimeUnit;", "(Ljava/util/concurrent/TimeUnit;)V", "getPrecision", "()Ljava/util/concurrent/TimeUnit;", "fromJson", "reader", "Lcom/squareup/moshi/JsonReader;", "toJson", "", "writer", "Lcom/squareup/moshi/JsonWriter;", "value", "lib"})
    private static final class Adapter
    extends JsonAdapter<Date> {
        @NotNull
        private final TimeUnit precision;

        @Nullable
        public Date fromJson(@NotNull JsonReader reader) {
            Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
            if (reader.peek() == JsonReader.Token.BOOLEAN) {
                reader.readJsonValue();
                return null;
            }
            if (reader.peek() == JsonReader.Token.NUMBER) {
                return new Date(TimeUnit.MILLISECONDS.convert(reader.nextLong(), this.precision));
            }
            throw (Throwable)new IllegalArgumentException("Expected a boolean or number value, got " + reader.peek());
        }

        public void toJson(@NotNull JsonWriter writer, @Nullable Date value) {
            Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
            if (value == null) {
                writer.value(false);
            } else {
                writer.value(this.precision.convert(value.getTime(), TimeUnit.MILLISECONDS));
            }
        }

        @NotNull
        public final TimeUnit getPrecision() {
            return this.precision;
        }

        public Adapter(@NotNull TimeUnit precision) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)precision), (String)"precision");
            this.precision = precision;
        }
    }
}

