/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.http;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.dean.jraw.Endpoint;
import net.dean.jraw.JrawUtils;
import net.dean.jraw.http.BasicAuthData;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001 B=\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020\u0007H\u0016R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0016\u00a8\u0006!"}, d2={"Lnet/dean/jraw/http/HttpRequest;", "", "parsedUrl", "Lokhttp3/HttpUrl;", "headers", "Lokhttp3/Headers;", "method", "", "body", "Lokhttp3/RequestBody;", "basicAuth", "Lnet/dean/jraw/http/BasicAuthData;", "rawJson", "", "(Lokhttp3/HttpUrl;Lokhttp3/Headers;Ljava/lang/String;Lokhttp3/RequestBody;Lnet/dean/jraw/http/BasicAuthData;Z)V", "getBasicAuth", "()Lnet/dean/jraw/http/BasicAuthData;", "getBody", "()Lokhttp3/RequestBody;", "getHeaders", "()Lokhttp3/Headers;", "getMethod", "()Ljava/lang/String;", "getParsedUrl", "()Lokhttp3/HttpUrl;", "getRawJson", "()Z", "url", "getUrl", "newBuilder", "Lnet/dean/jraw/http/HttpRequest$Builder;", "toString", "Builder", "lib"})
public final class HttpRequest {
    @NotNull
    private final String url;
    @NotNull
    private final HttpUrl parsedUrl;
    @NotNull
    private final Headers headers;
    @NotNull
    private final String method;
    @Nullable
    private final RequestBody body;
    @Nullable
    private final BasicAuthData basicAuth;
    private final boolean rawJson;

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final Builder newBuilder() {
        return new Builder().url(this.parsedUrl).headers(this.headers).method(this.method, this.body).basicAuth(this.basicAuth).rawJson(this.rawJson);
    }

    @NotNull
    public String toString() {
        return "HttpRequest(url='" + this.url + "', headers=" + this.headers + ", method='" + this.method + "', body=" + this.body + ", basicAuth=" + this.basicAuth + ", rawJson=" + this.rawJson + ')';
    }

    @NotNull
    public final HttpUrl getParsedUrl() {
        return this.parsedUrl;
    }

    @NotNull
    public final Headers getHeaders() {
        return this.headers;
    }

    @NotNull
    public final String getMethod() {
        return this.method;
    }

    @Nullable
    public final RequestBody getBody() {
        return this.body;
    }

    @Nullable
    public final BasicAuthData getBasicAuth() {
        return this.basicAuth;
    }

    public final boolean getRawJson() {
        return this.rawJson;
    }

    public HttpRequest(@NotNull HttpUrl parsedUrl, @NotNull Headers headers, @NotNull String method, @Nullable RequestBody body2, @Nullable BasicAuthData basicAuth, boolean rawJson) {
        Intrinsics.checkParameterIsNotNull((Object)parsedUrl, (String)"parsedUrl");
        Intrinsics.checkParameterIsNotNull((Object)headers, (String)"headers");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        this.parsedUrl = parsedUrl;
        this.headers = headers;
        this.method = method;
        this.body = body2;
        this.basicAuth = basicAuth;
        this.rawJson = rawJson;
        String string = this.parsedUrl.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parsedUrl.toString()");
        this.url = string;
    }

    public /* synthetic */ HttpRequest(HttpUrl httpUrl, Headers headers, String string, RequestBody requestBody, BasicAuthData basicAuthData, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            bl = true;
        }
        this(httpUrl, headers, string, requestBody, basicAuthData, bl);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 /2\u00020\u0001:\u0001/B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00002\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0010J\u0010\u0010\u0003\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004J\u0006\u0010\u0011\u001a\u00020\u0012J)\u0010\u0013\u001a\u00020\u00002!\u0010\u0014\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\u0015J\u0006\u0010\u0018\u001a\u00020\u0000J+\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001b2\u0016\u0010\u001c\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\n0\u001d\"\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u001eJ\u0006\u0010\u001f\u001a\u00020\u0000J\u0016\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\nJ\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020#J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\nJ\"\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0%J\u001a\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u001a\u0010&\u001a\u00020\u00002\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0%J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J'\u0010'\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\n2\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u001d\"\u00020\n\u00a2\u0006\u0002\u0010(J\u001a\u0010)\u001a\u00020\u00002\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0%J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010*\u001a\u00020\u00002\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0%J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010+\u001a\u00020\u00002\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0%J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010,\u001a\u00020\u00002\b\b\u0002\u0010-\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\nJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020.R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lnet/dean/jraw/http/HttpRequest$Builder;", "", "()V", "basicAuth", "Lnet/dean/jraw/http/BasicAuthData;", "body", "Lokhttp3/RequestBody;", "headers", "Lokhttp3/Headers$Builder;", "method", "", "rawJson", "", "url", "Lokhttp3/HttpUrl$Builder;", "creds", "Lkotlin/Pair;", "build", "Lnet/dean/jraw/http/HttpRequest;", "configureUrl", "modify", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "delete", "endpoint", "e", "Lnet/dean/jraw/Endpoint;", "pathParams", "", "(Lnet/dean/jraw/Endpoint;[Ljava/lang/String;)Lnet/dean/jraw/http/HttpRequest$Builder;", "get", "header", "key", "value", "Lokhttp3/Headers;", "host", "", "patch", "path", "(Ljava/lang/String;[Ljava/lang/String;)Lnet/dean/jraw/http/HttpRequest$Builder;", "post", "put", "query", "secure", "flag", "Lokhttp3/HttpUrl;", "Companion", "lib"})
    public static final class Builder {
        private String method = "GET";
        private Headers.Builder headers = new Headers.Builder();
        private RequestBody body;
        private HttpUrl.Builder url;
        private BasicAuthData basicAuth;
        private boolean rawJson;
        private static final Pattern PATH_PARAM_PATTERN;
        public static final Companion Companion;

        @NotNull
        public final Builder method(@NotNull String method, @Nullable RequestBody body2) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
            String string2 = method;
            Builder builder = this;
            String string3 = string2 = (string = ((Object)StringsKt.trim((CharSequence)string2)).toString());
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toUpperCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toUpperCase()");
            builder.method = string = string4;
            this.body = body2;
            return this;
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Builder method$default(Builder builder, String string, RequestBody requestBody, int n, Object object) {
            if ((n & 2) != 0) {
                requestBody = null;
            }
            return builder.method(string, requestBody);
        }

        @NotNull
        public final Builder method(@NotNull String method, @NotNull Map<String, String> body2) {
            Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
            Intrinsics.checkParameterIsNotNull(body2, (String)"body");
            this.method = method;
            FormBody.Builder formBodyBuilder = new FormBody.Builder();
            Map<String, String> map = body2;
            Iterator<Map.Entry<String, String>> iterator2 = map.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, String> entry;
                Map.Entry<String, String> entry2 = entry = iterator2.next();
                String k = entry2.getKey();
                entry2 = entry;
                String v = entry2.getValue();
                formBodyBuilder.add(k, v);
            }
            this.body = (RequestBody)formBodyBuilder.build();
            return this;
        }

        @NotNull
        public final Builder get() {
            return Builder.method$default(this, "GET", null, 2, null);
        }

        @NotNull
        public final Builder delete() {
            return Builder.method$default(this, "DELETE", null, 2, null);
        }

        @NotNull
        public final Builder post(@NotNull Map<String, String> body2) {
            Intrinsics.checkParameterIsNotNull(body2, (String)"body");
            return this.method("POST", body2);
        }

        @NotNull
        public final Builder post(@NotNull RequestBody body2) {
            Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
            return this.method("POST", body2);
        }

        @NotNull
        public final Builder put(@NotNull Map<String, String> body2) {
            Intrinsics.checkParameterIsNotNull(body2, (String)"body");
            return this.method("PUT", body2);
        }

        @NotNull
        public final Builder put(@NotNull RequestBody body2) {
            Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
            return this.method("PUT", body2);
        }

        @NotNull
        public final Builder patch(@NotNull Map<String, String> body2) {
            Intrinsics.checkParameterIsNotNull(body2, (String)"body");
            return this.method("PATCH", body2);
        }

        @NotNull
        public final Builder patch(@NotNull RequestBody body2) {
            Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
            return this.method("PATCH", body2);
        }

        @NotNull
        public final Builder configureUrl(@NotNull Function1<? super HttpUrl.Builder, HttpUrl.Builder> modify) {
            Intrinsics.checkParameterIsNotNull(modify, (String)"modify");
            this.url = (HttpUrl.Builder)modify.invoke((Object)this.url);
            return this;
        }

        @NotNull
        public final Builder url(@NotNull HttpUrl url) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            HttpUrl.Builder builder = url.newBuilder();
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"url.newBuilder()");
            this.url = builder;
            return this;
        }

        @NotNull
        public final Builder url(@NotNull String url) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            HttpUrl httpUrl = HttpUrl.parse((String)url);
            if (httpUrl == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"HttpUrl.parse(url)!!");
            return this.url(httpUrl);
        }

        @NotNull
        public final Builder headers(@NotNull Headers headers) {
            Intrinsics.checkParameterIsNotNull((Object)headers, (String)"headers");
            Headers.Builder builder = headers.newBuilder();
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"headers.newBuilder()");
            this.headers = builder;
            return this;
        }

        @NotNull
        public final Builder header(@NotNull String key, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.headers.set(key, value);
            return this;
        }

        @NotNull
        public final Builder basicAuth(@NotNull Pair<String, String> creds) {
            Intrinsics.checkParameterIsNotNull(creds, (String)"creds");
            return this.basicAuth(new BasicAuthData((String)creds.getFirst(), (String)creds.getSecond()));
        }

        @NotNull
        public final Builder basicAuth(@Nullable BasicAuthData creds) {
            this.basicAuth = creds;
            return this;
        }

        @NotNull
        public final Builder secure(boolean flag) {
            this.url.scheme("http" + (flag ? "s" : ""));
            return this;
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Builder secure$default(Builder builder, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = true;
            }
            return builder.secure(bl);
        }

        @NotNull
        public final Builder host(@NotNull String host) {
            Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
            this.url.host(host);
            return this;
        }

        @NotNull
        public final Builder endpoint(@NotNull Endpoint e, String ... pathParams) {
            Builder builder;
            block9: {
                block6: {
                    Collection $receiver$iv;
                    String string;
                    block8: {
                        block7: {
                            String string2;
                            Intrinsics.checkParameterIsNotNull((Object)((Object)e), (String)"e");
                            Intrinsics.checkParameterIsNotNull((Object)pathParams, (String)"pathParams");
                            this.url.host("oauth.reddit.com");
                            if (!StringsKt.startsWith$default((String)e.getPath(), (String)"[/r/{subreddit}]", (boolean)false, (int)2, null)) break block6;
                            String[] stringArray = pathParams;
                            if (stringArray.length == 0) {
                                throw (Throwable)new IllegalArgumentException("Expected at least one path argument for endpoint with optional subreddit");
                            }
                            string = pathParams[0];
                            if (string == null) break block7;
                            String it = string2 = string;
                            string = "/r/" + JrawUtils.urlEncode(it);
                            if (string != null) break block8;
                        }
                        string = "";
                    }
                    String optionalPath = string;
                    String requiredPath = StringsKt.substringAfter$default((String)e.getPath(), (String)"[/r/{subreddit}]", null, (int)2, null);
                    Collection collection = $receiver$iv = (Collection)ArraysKt.drop((Object[])pathParams, (int)1);
                    if (collection == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                    }
                    Collection thisCollection$iv = collection;
                    Object[] objectArray = thisCollection$iv.toArray(new String[0]);
                    if (objectArray == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    String[] requiredPathParams = (String[])ArraysKt.requireNoNulls((Object[])objectArray);
                    builder = this.path(optionalPath + requiredPath, Arrays.copyOf(requiredPathParams, requiredPathParams.length));
                    break block9;
                }
                String string = e.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"e.path");
                String[] stringArray = (String[])ArraysKt.requireNoNulls((Object[])pathParams);
                builder = this.path(string, Arrays.copyOf(stringArray, stringArray.length));
            }
            return builder;
        }

        @NotNull
        public final Builder path(@NotNull String path, String ... pathParams) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)pathParams, (String)"pathParams");
            String realPath = StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) ? path : "/" + path;
            this.url.encodedPath(Builder.Companion.substitutePathParameters(realPath, ArraysKt.toList((Object[])pathParams)));
            return this;
        }

        @NotNull
        public final Builder query(@NotNull Map<String, String> query) {
            Intrinsics.checkParameterIsNotNull(query, (String)"query");
            Map<String, String> map = query;
            Iterator<Map.Entry<String, String>> iterator2 = map.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, String> entry;
                Map.Entry<String, String> entry2 = entry = iterator2.next();
                String k = entry2.getKey();
                entry2 = entry;
                String v = entry2.getValue();
                this.url.addQueryParameter(k, v);
            }
            return this;
        }

        @NotNull
        public final Builder rawJson(boolean rawJson) {
            this.rawJson = rawJson;
            return this;
        }

        @NotNull
        public final HttpRequest build() {
            HttpUrl httpUrl = this.url.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"url.build()");
            Headers headers = this.headers.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)headers, (String)"headers.build()");
            return new HttpRequest(httpUrl, headers, this.method, this.body, this.basicAuth, this.rawJson);
        }

        public Builder() {
            HttpUrl.Builder builder = new HttpUrl.Builder().scheme("https");
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"HttpUrl.Builder()\n            .scheme(\"https\")");
            this.url = builder;
            this.rawJson = true;
        }

        static {
            Companion = new Companion(null);
            PATH_PARAM_PATTERN = Pattern.compile("\\{(.*?)\\}");
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\bH\u0002J\u001e\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lnet/dean/jraw/http/HttpRequest$Builder$Companion;", "", "()V", "PATH_PARAM_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "parsePathParams", "", "", "path", "substitutePathParameters", "positionalArgs", "lib"})
        public static final class Companion {
            /*
             * WARNING - void declaration
             */
            private final String substitutePathParameters(String path, List<String> positionalArgs) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                List<String> pathParams = this.parsePathParams(path);
                if (pathParams.size() != positionalArgs.size()) {
                    throw (Throwable)new IllegalArgumentException("URL parameter size mismatch. Expecting " + pathParams.size() + ", got " + positionalArgs.size());
                }
                String updatedUri = path;
                Matcher m = null;
                Iterable iterable = $receiver$iv = (Iterable)positionalArgs;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    String string2 = JrawUtils.urlEncode((String)it);
                    collection.add(string2);
                }
                for (String arg : (List)destination$iv$iv) {
                    if (m == null) {
                        m = PATH_PARAM_PATTERN.matcher(updatedUri);
                    } else {
                        m.reset(updatedUri);
                    }
                    Matcher matcher = m;
                    if (matcher == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)matcher.replaceFirst(arg), (String)"m!!.replaceFirst(arg)");
                }
                return updatedUri;
            }

            private final List<String> parsePathParams(String path) {
                ArrayList<String> params = new ArrayList<String>();
                Matcher matcher = PATH_PARAM_PATTERN.matcher(path);
                while (matcher.find()) {
                    params.add(matcher.group());
                }
                return params;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

