/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.http;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dean.jraw.http.BasicAuthData;
import net.dean.jraw.http.BasicAuthenticator;
import net.dean.jraw.http.HttpRequest;
import net.dean.jraw.http.HttpResponse;
import net.dean.jraw.http.NetworkAdapter;
import net.dean.jraw.http.UserAgent;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lnet/dean/jraw/http/OkHttpNetworkAdapter;", "Lnet/dean/jraw/http/NetworkAdapter;", "userAgent", "Lnet/dean/jraw/http/UserAgent;", "http", "Lokhttp3/OkHttpClient;", "(Lnet/dean/jraw/http/UserAgent;Lokhttp3/OkHttpClient;)V", "getUserAgent", "()Lnet/dean/jraw/http/UserAgent;", "setUserAgent", "(Lnet/dean/jraw/http/UserAgent;)V", "compileRequest", "Lokhttp3/Request;", "r", "Lnet/dean/jraw/http/HttpRequest;", "connect", "Lokhttp3/WebSocket;", "url", "", "listener", "Lokhttp3/WebSocketListener;", "createAuthenticatedClient", "data", "Lnet/dean/jraw/http/BasicAuthData;", "createCall", "Lokhttp3/Call;", "execute", "Lnet/dean/jraw/http/HttpResponse;", "lib"})
public final class OkHttpNetworkAdapter
implements NetworkAdapter {
    @NotNull
    private UserAgent userAgent;
    private final OkHttpClient http;

    @Override
    @NotNull
    public HttpResponse execute(@NotNull HttpRequest r) {
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        Response response = this.createCall(r).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"createCall(r).execute()");
        return new HttpResponse(response);
    }

    @Override
    @NotNull
    public WebSocket connect(@NotNull String url, @NotNull WebSocketListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        OkHttpClient client = new OkHttpClient();
        WebSocket ws = client.newWebSocket(new Request.Builder().get().url(url).build(), listener);
        client.dispatcher().executorService().shutdown();
        WebSocket webSocket = ws;
        Intrinsics.checkExpressionValueIsNotNull((Object)webSocket, (String)"ws");
        return webSocket;
    }

    private final Call createCall(HttpRequest r) {
        Call call = (r.getBasicAuth() != null ? this.createAuthenticatedClient(r.getBasicAuth()) : this.http).newCall(this.compileRequest(r));
        Intrinsics.checkExpressionValueIsNotNull((Object)call, (String)"(if (r.basicAuth != null\u2026ewCall(compileRequest(r))");
        return call;
    }

    private final OkHttpClient createAuthenticatedClient(BasicAuthData data2) {
        OkHttpClient okHttpClient = this.http.newBuilder().authenticator((Authenticator)new BasicAuthenticator(data2)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient, (String)"http.newBuilder().authen\u2026henticator(data)).build()");
        return okHttpClient;
    }

    private final Request compileRequest(HttpRequest r) {
        Request request2 = new Request.Builder().headers(r.getHeaders().newBuilder().set("User-Agent", this.getUserAgent().getValue()).build()).url(r.getUrl()).method(r.getMethod(), r.getBody()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)request2, (String)"Request.Builder()\n      \u2026ody)\n            .build()");
        return request2;
    }

    @Override
    @NotNull
    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    @Override
    public void setUserAgent(@NotNull UserAgent userAgent) {
        Intrinsics.checkParameterIsNotNull((Object)userAgent, (String)"<set-?>");
        this.userAgent = userAgent;
    }

    @JvmOverloads
    public OkHttpNetworkAdapter(@NotNull UserAgent userAgent, @NotNull OkHttpClient http) {
        Intrinsics.checkParameterIsNotNull((Object)userAgent, (String)"userAgent");
        Intrinsics.checkParameterIsNotNull((Object)http, (String)"http");
        this.userAgent = userAgent;
        this.http = http;
    }

    @JvmOverloads
    public /* synthetic */ OkHttpNetworkAdapter(UserAgent userAgent, OkHttpClient okHttpClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            okHttpClient = new OkHttpClient();
        }
        this(userAgent, okHttpClient);
    }

    @JvmOverloads
    public OkHttpNetworkAdapter(@NotNull UserAgent userAgent) {
        this(userAgent, null, 2, null);
    }
}

