/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.http;

import java.io.PrintStream;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.dean.jraw.JrawUtils;
import net.dean.jraw.http.HttpLogger;
import net.dean.jraw.http.HttpRequest;
import net.dean.jraw.http.HttpResponse;
import net.dean.jraw.http.LogAdapter;
import net.dean.jraw.http.PrintStreamLogAdapter;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\u001b\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J,\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u000e2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0016H\u0002J\u001c\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020#H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006%"}, d2={"Lnet/dean/jraw/http/SimpleHttpLogger;", "Lnet/dean/jraw/http/HttpLogger;", "maxLineLength", "", "out", "Lnet/dean/jraw/http/LogAdapter;", "(ILnet/dean/jraw/http/LogAdapter;)V", "counter", "Ljava/util/concurrent/atomic/AtomicInteger;", "getMaxLineLength", "()I", "getOut", "()Lnet/dean/jraw/http/LogAdapter;", "formatContentType", "", "res", "Lokhttp3/Response;", "logMap", "", "baseIndentLength", "header", "pairs", "", "parseForm", "r", "Lnet/dean/jraw/http/HttpRequest;", "readRequestBody", "body", "Lokhttp3/RequestBody;", "request", "Lnet/dean/jraw/http/HttpLogger$Tag;", "sent", "Ljava/util/Date;", "response", "tag", "Lnet/dean/jraw/http/HttpResponse;", "Companion", "lib"})
public final class SimpleHttpLogger
implements HttpLogger {
    private final AtomicInteger counter;
    private final int maxLineLength;
    @NotNull
    private final LogAdapter out;
    @NotNull
    private static final String ELLIPSIS = "(...)";
    private static final String NO_CONTENT_TYPE = "<no content type>";
    public static final int DEFAULT_LINE_LENGTH = 200;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public HttpLogger.Tag request(@NotNull HttpRequest r, @NotNull Date sent) {
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        Intrinsics.checkParameterIsNotNull((Object)sent, (String)"sent");
        int id = this.counter.getAndIncrement();
        String tag = "" + '[' + id + " ->]";
        this.out.writeln(SimpleHttpLogger.Companion.truncate("" + tag + ' ' + r.getMethod() + ' ' + r.getUrl(), this.maxLineLength));
        Map<String, String> form = this.parseForm(r);
        if (!form.isEmpty()) {
            this.logMap(tag.length(), "form:", form);
        }
        return new HttpLogger.Tag(id, sent);
    }

    @Override
    public void response(@NotNull HttpLogger.Tag tag, @NotNull HttpResponse res2) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)res2, (String)"res");
        String contentType = this.formatContentType(res2.getRaw());
        String body2 = StringsKt.replace$default((String)res2.getBody(), (String)"\n", (String)"", (boolean)false, (int)4, null);
        String formattedTag = "[<- " + tag.getRequestId() + ']';
        this.out.writeln(SimpleHttpLogger.Companion.truncate("" + formattedTag + ' ' + res2.getCode() + ' ' + contentType + ": '" + body2 + '\'', this.maxLineLength));
    }

    private final String formatContentType(Response res2) {
        ResponseBody responseBody = res2.body();
        if (responseBody == null || (responseBody = responseBody.contentType()) == null) {
            return NO_CONTENT_TYPE;
        }
        ResponseBody type = responseBody;
        return type.type() + '/' + type.subtype();
    }

    private final Map<String, String> parseForm(HttpRequest r) {
        MediaType type;
        if (r.getBody() == null) {
            return MapsKt.emptyMap();
        }
        MediaType mediaType = r.getBody().contentType();
        if (mediaType == null) {
            Intrinsics.throwNpe();
        }
        if (Intrinsics.areEqual((Object)(type = mediaType).type(), (Object)"application") ^ true || Intrinsics.areEqual((Object)type.subtype(), (Object)"x-www-form-urlencoded") ^ true) {
            return MapsKt.emptyMap();
        }
        return JrawUtils.parseUrlEncoded(this.readRequestBody(r.getBody()));
    }

    private final String readRequestBody(RequestBody body2) {
        Buffer buff = new Buffer();
        body2.writeTo((BufferedSink)buff);
        return StringsKt.replace$default((String)buff.readUtf8(), (String)"\n", (String)"", (boolean)false, (int)4, null);
    }

    private final void logMap(int baseIndentLength, String header, Map<String, String> pairs) {
        boolean needsHeader = true;
        String baseIndent = StringsKt.repeat((CharSequence)" ", (int)baseIndentLength);
        Map<String, String> map = pairs;
        Iterator<Map.Entry<String, String>> iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            String prefix;
            Map.Entry<String, String> entry;
            Map.Entry<String, String> entry2 = entry = iterator2.next();
            String k = entry2.getKey();
            entry2 = entry;
            String v = entry2.getValue();
            String string = prefix = needsHeader ? header : StringsKt.repeat((CharSequence)" ", (int)header.length());
            if (needsHeader) {
                needsHeader = false;
            }
            this.out.writeln(SimpleHttpLogger.Companion.truncate("" + baseIndent + ' ' + prefix + ' ' + k + '=' + v, this.maxLineLength));
        }
    }

    public final int getMaxLineLength() {
        return this.maxLineLength;
    }

    @NotNull
    public final LogAdapter getOut() {
        return this.out;
    }

    @JvmOverloads
    public SimpleHttpLogger(int maxLineLength, @NotNull LogAdapter out) {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        this.maxLineLength = maxLineLength;
        this.out = out;
        this.counter = new AtomicInteger(1);
        if (this.maxLineLength >= 0 && this.maxLineLength <= ELLIPSIS.length()) {
            throw (Throwable)new IllegalArgumentException("maxLineLength must be less than 0 or greater than " + ELLIPSIS.length());
        }
    }

    @JvmOverloads
    public /* synthetic */ SimpleHttpLogger(int n, LogAdapter logAdapter, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 200;
        }
        if ((n2 & 2) != 0) {
            PrintStream printStream = System.out;
            Intrinsics.checkExpressionValueIsNotNull((Object)printStream, (String)"System.out");
            logAdapter = new PrintStreamLogAdapter(printStream);
        }
        this(n, logAdapter);
    }

    @JvmOverloads
    public SimpleHttpLogger(int maxLineLength) {
        this(maxLineLength, null, 2, null);
    }

    @JvmOverloads
    public SimpleHttpLogger() {
        this(0, null, 3, null);
    }

    static {
        ELLIPSIS = ELLIPSIS;
        NO_CONTENT_TYPE = NO_CONTENT_TYPE;
    }

    @JvmStatic
    private static final String truncate(String str, int limit) {
        return SimpleHttpLogger.Companion.truncate(str, limit);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0004H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lnet/dean/jraw/http/SimpleHttpLogger$Companion;", "", "()V", "DEFAULT_LINE_LENGTH", "", "ELLIPSIS", "", "getELLIPSIS$lib", "()Ljava/lang/String;", "NO_CONTENT_TYPE", "truncate", "str", "limit", "lib"})
    public static final class Companion {
        @NotNull
        public final String getELLIPSIS$lib() {
            return ELLIPSIS;
        }

        @JvmStatic
        private final String truncate(String str, int limit) {
            String string;
            if (limit < 0) {
                return str;
            }
            if (str.length() > limit) {
                String string2 = str;
                int n = 0;
                int n2 = limit - this.getELLIPSIS$lib().length();
                StringBuilder stringBuilder = new StringBuilder();
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string5 = string4;
                string = stringBuilder.append(string5).append(this.getELLIPSIS$lib()).toString();
            } else {
                string = str;
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

