/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.models;

import com.google.auto.value.AutoValue;
import com.squareup.moshi.Json;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.Serializable;
import java.util.Date;
import net.dean.jraw.RedditClient;
import net.dean.jraw.databind.RedditModel;
import net.dean.jraw.databind.UnixTime;
import net.dean.jraw.models.AutoValue_Account;
import net.dean.jraw.models.Created;
import net.dean.jraw.models.UniquelyIdentifiable;
import net.dean.jraw.references.Referenceable;
import net.dean.jraw.references.UserReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RedditModel
@AutoValue
public abstract class Account
implements Created,
Referenceable<UserReference<?>>,
Serializable,
UniquelyIdentifiable {
    @Json(name="comment_karma")
    public abstract int getCommentKarma();

    @Override
    @Json(name="created_utc")
    @UnixTime
    @NotNull
    public abstract Date getCreated();

    @Json(name="is_friend")
    public abstract boolean isFriend();

    @Json(name="is_mod")
    public abstract boolean isModerator();

    @Json(name="is_gold")
    public abstract boolean isGoldMember();

    @Json(name="has_subscribed")
    public abstract boolean getHasSubscribed();

    @Json(name="has_verified_email")
    @Nullable
    public abstract Boolean getHasVerifiedEmail();

    @Json(name="link_karma")
    public abstract int getLinkKarma();

    @Json(name="name")
    public abstract String getName();

    @Override
    @NotNull
    public String getUniqueId() {
        return this.getName();
    }

    @Override
    @NotNull
    public UserReference toReference(@NotNull RedditClient reddit) {
        return reddit.user(this.getName());
    }

    public static JsonAdapter<Account> jsonAdapter(Moshi moshi) {
        return new AutoValue_Account.MoshiJsonAdapter(moshi);
    }
}

