/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.models;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonQualifier;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import net.dean.jraw.models.$AutoValue_OAuthData;
import net.dean.jraw.models.OAuthData;

final class AutoValue_OAuthData
extends $AutoValue_OAuthData {
    AutoValue_OAuthData(String accessToken, List<String> scopes, String refreshToken, Date expiration) {
        super(accessToken, scopes, refreshToken, expiration);
    }

    public static final class MoshiJsonAdapter
    extends JsonAdapter<OAuthData> {
        private static final String[] NAMES = new String[]{"accessToken", "scopes", "refreshToken", "expiration"};
        private static final JsonReader.Options OPTIONS = JsonReader.Options.of((String[])NAMES);
        private final JsonAdapter<String> accessTokenAdapter;
        private final JsonAdapter<List<String>> scopesAdapter;
        private final JsonAdapter<String> refreshTokenAdapter;
        private final JsonAdapter<Date> expirationAdapter;

        public MoshiJsonAdapter(Moshi moshi) {
            this.accessTokenAdapter = this.adapter(moshi, (Type)((Object)String.class));
            this.scopesAdapter = this.adapter(moshi, Types.newParameterizedType(List.class, (Type[])new Type[]{String.class}));
            this.refreshTokenAdapter = this.adapter(moshi, (Type)((Object)String.class)).nullSafe();
            this.expirationAdapter = this.adapterWithQualifier(moshi, "getExpiration", null);
        }

        public OAuthData fromJson(JsonReader reader) throws IOException {
            reader.beginObject();
            String accessToken = null;
            List scopes = null;
            String refreshToken = null;
            Date expiration = null;
            while (reader.hasNext()) {
                switch (reader.selectName(OPTIONS)) {
                    case 0: {
                        accessToken = (String)this.accessTokenAdapter.fromJson(reader);
                        break;
                    }
                    case 1: {
                        scopes = (List)this.scopesAdapter.fromJson(reader);
                        break;
                    }
                    case 2: {
                        refreshToken = (String)this.refreshTokenAdapter.fromJson(reader);
                        break;
                    }
                    case 3: {
                        expiration = (Date)this.expirationAdapter.fromJson(reader);
                        break;
                    }
                    case -1: {
                        reader.nextName();
                        reader.skipValue();
                    }
                }
            }
            reader.endObject();
            return new AutoValue_OAuthData(accessToken, scopes, refreshToken, expiration);
        }

        public void toJson(JsonWriter writer, OAuthData value) throws IOException {
            writer.beginObject();
            writer.name("accessToken");
            this.accessTokenAdapter.toJson(writer, (Object)value.getAccessToken());
            writer.name("scopes");
            this.scopesAdapter.toJson(writer, value.getScopes());
            String refreshToken = value.getRefreshToken();
            if (refreshToken != null) {
                writer.name("refreshToken");
                this.refreshTokenAdapter.toJson(writer, (Object)refreshToken);
            }
            writer.name("expiration");
            this.expirationAdapter.toJson(writer, (Object)value.getExpiration());
            writer.endObject();
        }

        private JsonAdapter adapter(Moshi moshi, Type adapterType) {
            return moshi.adapter(adapterType);
        }

        private JsonAdapter adapterWithQualifier(Moshi moshi, String methodName, Type declaredGenericType) {
            try {
                Method method = OAuthData.class.getMethod(methodName, new Class[0]);
                LinkedHashSet<Annotation> annotations = new LinkedHashSet<Annotation>();
                for (Annotation annotation : method.getAnnotations()) {
                    if (!annotation.annotationType().isAnnotationPresent(JsonQualifier.class)) continue;
                    annotations.add(annotation);
                }
                Type adapterType = method.getGenericReturnType();
                if (declaredGenericType != null) {
                    if (adapterType instanceof ParameterizedType) {
                        adapterType = Types.newParameterizedType((Type)((ParameterizedType)adapterType).getRawType(), (Type[])new Type[]{declaredGenericType});
                    } else if (adapterType instanceof TypeVariable) {
                        adapterType = declaredGenericType;
                    }
                }
                return moshi.adapter(adapterType, annotations);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("No method named " + methodName, e);
            }
        }
    }
}

