/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.models;

import com.google.auto.value.AutoValue;
import com.squareup.moshi.Json;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.Serializable;
import java.util.Date;
import net.dean.jraw.RedditClient;
import net.dean.jraw.databind.Enveloped;
import net.dean.jraw.databind.RedditModel;
import net.dean.jraw.databind.UnixTime;
import net.dean.jraw.models.AutoValue_Comment;
import net.dean.jraw.models.DistinguishedStatus;
import net.dean.jraw.models.Listing;
import net.dean.jraw.models.NestedIdentifiable;
import net.dean.jraw.models.PublicContribution;
import net.dean.jraw.models.Subreddit;
import net.dean.jraw.models.VoteDirection;
import net.dean.jraw.references.CommentReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RedditModel
@AutoValue
public abstract class Comment
implements PublicContribution<CommentReference>,
NestedIdentifiable,
Serializable {
    public abstract boolean isArchived();

    @Override
    @NotNull
    public abstract String getAuthor();

    @Json(name="author_flair_text")
    @Nullable
    public abstract String getAuthorFlairText();

    @Override
    @Json(name="can_gild")
    public abstract boolean isGildable();

    public abstract int getControversiality();

    @Override
    @Json(name="created_utc")
    @UnixTime
    @NotNull
    public abstract Date getCreated();

    @Override
    @NotNull
    public abstract DistinguishedStatus getDistinguished();

    @Override
    @UnixTime
    @Nullable
    public abstract Date getEdited();

    @Override
    @Json(name="name")
    @NotNull
    public abstract String getFullName();

    @Override
    @NotNull
    public abstract String getBody();

    @Enveloped
    public abstract Listing<NestedIdentifiable> getReplies();

    @Override
    @Json(name="parent_id")
    @NotNull
    public abstract String getParentFullName();

    @Json(name="link_id")
    @NotNull
    public abstract String getSubmissionFullName();

    @Json(name="link_title")
    @Nullable
    public abstract String getSubmissionTitle();

    @Json(name="link_url")
    @Nullable
    public abstract String getUrl();

    @Override
    @Json(name="subreddit_id")
    @NotNull
    public abstract String getSubredditFullName();

    @Json(name="subreddit_type")
    public abstract Subreddit.Access getSubredditType();

    @Override
    @Json(name="score_hidden")
    public abstract boolean isScoreHidden();

    @Override
    @NotNull
    public String getUniqueId() {
        return this.getFullName();
    }

    @Override
    @Json(name="likes")
    @NotNull
    public abstract VoteDirection getVote();

    @Override
    @NotNull
    public CommentReference toReference(@NotNull RedditClient reddit) {
        return new CommentReference(reddit, this.getId());
    }

    public static JsonAdapter<Comment> jsonAdapter(Moshi moshi) {
        return new AutoValue_Comment.MoshiJsonAdapter(moshi);
    }
}

