/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.models;

import com.google.auto.value.AutoValue;
import com.squareup.moshi.Json;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.Serializable;
import net.dean.jraw.models.AutoValue_EmbeddedMedia;
import net.dean.jraw.models.AutoValue_EmbeddedMedia_OEmbed;
import net.dean.jraw.models.AutoValue_EmbeddedMedia_RedditVideo;
import org.jetbrains.annotations.Nullable;

@AutoValue
public abstract class EmbeddedMedia
implements Serializable {
    @Nullable
    public abstract String getType();

    @Json(name="oembed")
    @Nullable
    public abstract OEmbed getOEmbed();

    @Json(name="event_id")
    @Nullable
    public abstract String getLiveThreadId();

    @Json(name="reddit_video")
    @Nullable
    public abstract RedditVideo getRedditVideo();

    public static EmbeddedMedia create(String type, OEmbed newOEmbed) {
        return EmbeddedMedia.create(type, newOEmbed, null, null);
    }

    public static EmbeddedMedia create(String liveThreadId) {
        return EmbeddedMedia.create("liveupdate", null, liveThreadId, null);
    }

    public static EmbeddedMedia create(String newType, OEmbed newOEmbed, String newLiveThreadId, RedditVideo vid) {
        return new AutoValue_EmbeddedMedia(newType, newOEmbed, newLiveThreadId, vid);
    }

    public static JsonAdapter<EmbeddedMedia> jsonAdapter(Moshi moshi) {
        return new AutoValue_EmbeddedMedia.MoshiJsonAdapter(moshi);
    }

    @AutoValue
    public static abstract class RedditVideo
    implements Serializable {
        @Json(name="fallback_url")
        public abstract String getFallbackUrl();

        public abstract int getHeight();

        public abstract int getWidth();

        @Json(name="scrubber_media_url")
        public abstract String getScrubberMediaUrl();

        @Json(name="dash_url")
        public abstract String getDashUrl();

        public abstract int getDuration();

        @Json(name="hls_url")
        public abstract String getHlsUrl();

        public static JsonAdapter<RedditVideo> jsonAdapter(Moshi moshi) {
            return new AutoValue_EmbeddedMedia_RedditVideo.MoshiJsonAdapter(moshi);
        }
    }

    @AutoValue
    public static abstract class OEmbed
    implements Serializable {
        public abstract String getType();

        public abstract String getVersion();

        @Nullable
        public abstract String getTitle();

        @Json(name="author_name")
        @Nullable
        public abstract String getAuthorName();

        @Json(name="author_url")
        @Nullable
        public abstract String getAuthorUrl();

        @Json(name="provider_name")
        @Nullable
        public abstract String getProviderName();

        @Json(name="provider_url")
        @Nullable
        public abstract String getProviderUrl();

        @Json(name="cache_age")
        @Nullable
        public abstract Long getCacheAge();

        @Json(name="thumbnail_url")
        @Nullable
        public abstract String getThumbnailUrl();

        @Json(name="thumbnail_width")
        @Nullable
        public abstract Integer getThumbnailWidth();

        @Json(name="thumbnail_height")
        @Nullable
        public abstract Integer getThumbnailHeight();

        @Nullable
        public abstract String getUrl();

        @Nullable
        public abstract Integer getWidth();

        @Nullable
        public abstract Integer getHeight();

        @Nullable
        public abstract String getEmbedHtml();

        public static OEmbed create(String newType, String newVersion, String newTitle, String newAuthorName, String newAuthorUrl, String newProviderName, String newProviderUrl, Long newCacheAge, String newThumbnailUrl, Integer newThumbnailWidth, Integer newThumbnailHeight, String newUrl, Integer newWidth, Integer newHeight, String newEmbedHtml) {
            return new AutoValue_EmbeddedMedia_OEmbed(newType, newVersion, newTitle, newAuthorName, newAuthorUrl, newProviderName, newProviderUrl, newCacheAge, newThumbnailUrl, newThumbnailWidth, newThumbnailHeight, newUrl, newWidth, newHeight, newEmbedHtml);
        }

        public static JsonAdapter<OEmbed> jsonAdapter(Moshi moshi) {
            return new AutoValue_EmbeddedMedia_OEmbed.MoshiJsonAdapter(moshi);
        }
    }
}

