/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.models;

import com.google.auto.value.AutoValue;
import com.squareup.moshi.Json;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.Serializable;
import java.util.Date;
import net.dean.jraw.RedditClient;
import net.dean.jraw.databind.RedditModel;
import net.dean.jraw.databind.UnixTime;
import net.dean.jraw.models.AutoValue_LiveThread;
import net.dean.jraw.models.Created;
import net.dean.jraw.models.Identifiable;
import net.dean.jraw.references.LiveThreadReference;
import net.dean.jraw.references.Referenceable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RedditModel
@AutoValue
public abstract class LiveThread
implements Created,
Identifiable,
Referenceable<LiveThreadReference>,
Serializable {
    @Override
    @Json(name="created_utc")
    @UnixTime
    @NotNull
    public abstract Date getCreated();

    public abstract String getDescription();

    @Override
    @Json(name="name")
    @NotNull
    public abstract String getFullName();

    public abstract boolean isNsfw();

    public abstract String getState();

    public abstract String getTitle();

    @Json(name="viewer_count")
    @Nullable
    public abstract Integer getViewerCount();

    @Json(name="viewer_count_fuzzed")
    @Nullable
    public abstract Boolean getViewerCountFuzzed();

    @Json(name="websocket_url")
    @Nullable
    public abstract String getWebsocketUrl();

    public abstract String getResources();

    @Override
    @NotNull
    public String getUniqueId() {
        return this.getFullName();
    }

    @Override
    @NotNull
    public LiveThreadReference toReference(@NotNull RedditClient reddit) {
        return reddit.liveThread(this.getId());
    }

    public static JsonAdapter<LiveThread> jsonAdapter(Moshi moshi) {
        return new AutoValue_LiveThread.MoshiJsonAdapter(moshi);
    }
}

