/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.models;

import com.google.auto.value.AutoValue;
import com.squareup.moshi.Json;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.dean.jraw.RedditClient;
import net.dean.jraw.databind.RedditModel;
import net.dean.jraw.databind.UnixTime;
import net.dean.jraw.models.AutoValue_Multireddit;
import net.dean.jraw.models.Created;
import net.dean.jraw.models.internal.SubredditElement;
import net.dean.jraw.references.MultiredditReference;
import net.dean.jraw.references.Referenceable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RedditModel
@AutoValue
public abstract class Multireddit
implements Created,
Referenceable<MultiredditReference>,
Serializable {
    private List<String> subreddits;

    @Json(name="can_edit")
    public abstract boolean isEditable();

    @Json(name="copied_from")
    @Nullable
    public abstract String getCopiedFrom();

    @Override
    @Json(name="created_utc")
    @UnixTime
    @NotNull
    public abstract Date getCreated();

    @Json(name="name")
    public abstract String getCodeName();

    @Json(name="description_md")
    public abstract String getDescription();

    @Json(name="display_name")
    public abstract String getDisplayName();

    @Json(name="icon_name")
    public abstract String getIconName();

    @Json(name="key_color")
    public abstract String getKeyColor();

    @Json(name="icon_url")
    @Nullable
    public abstract String getIconUrl();

    public abstract String getPath();

    @Json(name="subreddits")
    abstract List<SubredditElement> getSubredditElements();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSubreddits() {
        if (this.subreddits != null) {
            return this.subreddits;
        }
        Multireddit multireddit = this;
        synchronized (multireddit) {
            this.subreddits = new ArrayList<String>(this.getSubredditElements().size());
            for (SubredditElement sr : this.getSubredditElements()) {
                this.subreddits.add(sr.getName());
            }
        }
        return this.subreddits;
    }

    public abstract String getVisibility();

    @Json(name="weighting_scheme")
    public abstract String getWeightingScheme();

    @Override
    @NotNull
    public MultiredditReference toReference(@NotNull RedditClient reddit) {
        String[] parts = this.getPath().split("/");
        return reddit.user(parts[2]).multi(parts[4]);
    }

    public static JsonAdapter<Multireddit> jsonAdapter(Moshi moshi) {
        return new AutoValue_Multireddit.MoshiJsonAdapter(moshi);
    }
}

