/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.models;

import com.google.auto.value.AutoValue;
import com.squareup.moshi.Json;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.dean.jraw.models.AutoValue_MultiredditPatch;
import net.dean.jraw.models.internal.SubredditElement;
import org.jetbrains.annotations.Nullable;

@AutoValue
public abstract class MultiredditPatch
implements Serializable {
    @Json(name="description_md")
    @Nullable
    public abstract String getDescription();

    @Json(name="display_name")
    @Nullable
    public abstract String getDisplayName();

    @Json(name="icon_name")
    @Nullable
    public abstract String getIconName();

    @Json(name="key_color")
    @Nullable
    public abstract String getKeyColor();

    @Json(name="subreddits")
    @Nullable
    public abstract List<SubredditElement> getSubreddits();

    @Nullable
    public abstract String getVisibility();

    @Nullable
    public abstract String getWeightingScheme();

    public static JsonAdapter<MultiredditPatch> jsonAdapter(Moshi moshi) {
        return new AutoValue_MultiredditPatch.MoshiJsonAdapter(moshi);
    }

    public static final class Builder {
        private String description;
        private String displayName;
        private String iconName;
        private String keyColor;
        private List<String> subreddits;
        private String visibility;
        private String weightingScheme;

        public Builder description(String description2) {
            this.description = description2;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder iconName(String iconName) {
            this.iconName = iconName;
            return this;
        }

        public Builder keyColor(String keyColor) {
            this.keyColor = keyColor;
            return this;
        }

        public Builder subreddits(List<String> subreddits) {
            this.subreddits = subreddits;
            return this;
        }

        public Builder subreddits(String ... subreddits) {
            return this.subreddits(Arrays.asList(subreddits));
        }

        public Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        public Builder weightingScheme(String weightingScheme) {
            this.weightingScheme = weightingScheme;
            return this;
        }

        public MultiredditPatch build() {
            ArrayList<SubredditElement> subreddits = new ArrayList<SubredditElement>(this.subreddits == null ? 0 : this.subreddits.size());
            if (this.subreddits != null) {
                for (String name : this.subreddits) {
                    subreddits.add(SubredditElement.create(name));
                }
            }
            return new AutoValue_MultiredditPatch(this.description, this.displayName, this.iconName, this.keyColor, subreddits, this.visibility, this.weightingScheme);
        }
    }
}

