/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.models;

import com.google.auto.value.AutoValue;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.dean.jraw.databind.UnixTime;
import net.dean.jraw.models.AutoValue_OAuthData;
import org.jetbrains.annotations.Nullable;

@AutoValue
public abstract class OAuthData
implements Serializable {
    public abstract String getAccessToken();

    public abstract List<String> getScopes();

    @Nullable
    public abstract String getRefreshToken();

    @UnixTime(precision=TimeUnit.MILLISECONDS)
    public abstract Date getExpiration();

    public final boolean isExpired() {
        return this.getExpiration().before(new Date());
    }

    public static OAuthData create(String accessToken, List<String> scopes, String refreshToken, Date expiration) {
        return new AutoValue_OAuthData(accessToken, scopes, refreshToken, expiration);
    }

    public static JsonAdapter<OAuthData> jsonAdapter(Moshi moshi) {
        return new AutoValue_OAuthData.MoshiJsonAdapter(moshi);
    }
}

