/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.models;

import com.google.auto.value.AutoValue;
import com.squareup.moshi.Json;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.Serializable;
import java.util.Date;
import net.dean.jraw.RedditClient;
import net.dean.jraw.databind.RedditModel;
import net.dean.jraw.databind.UnixTime;
import net.dean.jraw.models.AutoValue_Submission;
import net.dean.jraw.models.CommentSort;
import net.dean.jraw.models.DistinguishedStatus;
import net.dean.jraw.models.EmbeddedMedia;
import net.dean.jraw.models.PublicContribution;
import net.dean.jraw.models.SubmissionPreview;
import net.dean.jraw.models.VoteDirection;
import net.dean.jraw.references.SubmissionReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RedditModel
@AutoValue
public abstract class Submission
implements PublicContribution<SubmissionReference>,
Serializable {
    @Override
    @Json(name="author")
    public abstract String getAuthor();

    @Json(name="author_flair_text")
    @Nullable
    public abstract String getAuthorFlairText();

    @Json(name="archived")
    public abstract boolean isArchived();

    @Override
    @Json(name="can_gild")
    public abstract boolean isGildable();

    @Override
    @Json(name="created_utc")
    @UnixTime
    @NotNull
    public abstract Date getCreated();

    @Json(name="contest_mode")
    public abstract boolean isContestMode();

    @Override
    @Json(name="distinguished")
    @NotNull
    public abstract DistinguishedStatus getDistinguished();

    public abstract String getDomain();

    @Override
    @UnixTime
    @Nullable
    public abstract Date getEdited();

    @Json(name="secure_media")
    @Nullable
    public abstract EmbeddedMedia getEmbeddedMedia();

    @Override
    @Json(name="name")
    @NotNull
    public abstract String getFullName();

    @Override
    @Json(name="gilded")
    public abstract short getGilded();

    public abstract boolean isHidden();

    @Override
    @Json(name="hide_score")
    public abstract boolean isScoreHidden();

    @Override
    @NotNull
    public abstract String getId();

    @Json(name="is_self")
    public abstract boolean isSelfPost();

    @Json(name="link_flair_text")
    @Nullable
    public abstract String getLinkFlairText();

    @Json(name="link_flair_css_class")
    @Nullable
    public abstract String getLinkFlairCssClass();

    public abstract boolean isLocked();

    @Json(name="over_18")
    public abstract boolean isNsfw();

    public abstract String getPermalink();

    @Json(name="post_hint")
    @Nullable
    public abstract String getPostHint();

    @Nullable
    public abstract SubmissionPreview getPreview();

    public abstract boolean isQuarantine();

    @Json(name="num_reports")
    @Nullable
    public abstract Integer getReports();

    @Json(name="selftext")
    @Nullable
    public abstract String getSelfText();

    public abstract boolean isSpam();

    public abstract boolean isSpoiler();

    @Override
    public abstract String getSubreddit();

    @Override
    @Json(name="subreddit_id")
    public abstract String getSubredditFullName();

    @Json(name="suggested_sort")
    @Nullable
    public abstract CommentSort getSuggestedSort();

    @Nullable
    public abstract String getThumbnail();

    public final boolean hasThumbnail() {
        String thumb = this.getThumbnail();
        return thumb != null && !thumb.isEmpty();
    }

    public abstract String getTitle();

    @Override
    @NotNull
    public String getUniqueId() {
        return this.getFullName();
    }

    public abstract String getUrl();

    public abstract boolean isVisited();

    public abstract boolean isRemoved();

    @Override
    @Json(name="likes")
    @NotNull
    public abstract VoteDirection getVote();

    @Json(name="num_comments")
    public abstract Integer getCommentCount();

    @Override
    @NotNull
    public SubmissionReference toReference(@NotNull RedditClient reddit) {
        return new SubmissionReference(reddit, this.getId());
    }

    public static JsonAdapter<Submission> jsonAdapter(Moshi moshi) {
        return new AutoValue_Submission.MoshiJsonAdapter(moshi);
    }
}

