/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.models;

import com.google.auto.value.AutoValue;
import com.squareup.moshi.Json;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.Serializable;
import java.util.Date;
import net.dean.jraw.RedditClient;
import net.dean.jraw.databind.RedditModel;
import net.dean.jraw.databind.UnixTime;
import net.dean.jraw.models.AutoValue_Subreddit;
import net.dean.jraw.models.CommentSort;
import net.dean.jraw.models.Created;
import net.dean.jraw.models.Identifiable;
import net.dean.jraw.references.Referenceable;
import net.dean.jraw.references.SubredditReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RedditModel
@AutoValue
public abstract class Subreddit
implements Created,
Identifiable,
Referenceable<SubredditReference>,
Serializable {
    @Json(name="accounts_active")
    @Nullable
    public abstract Integer getAccountsActive();

    @Json(name="accounts_active_fuzzed")
    public abstract boolean isAccountsActiveFuzzed();

    @Json(name="banner_img")
    @Nullable
    public abstract String getBannerImage();

    @Json(name="comment_score_hide_mins")
    @Nullable
    abstract Integer getCommentScoreHideMinsNullable();

    public final int getCommentScoreHideMins() {
        Integer result = this.getCommentScoreHideMinsNullable();
        return result == null ? -1 : result;
    }

    @Override
    @Json(name="created_utc")
    @UnixTime
    @NotNull
    public abstract Date getCreated();

    @Json(name="hide_ads")
    @Nullable
    public abstract Boolean getHideAds();

    @Override
    @Json(name="name")
    @NotNull
    public abstract String getFullName();

    @Json(name="key_color")
    @Nullable
    public abstract String getKeyColor();

    @Json(name="display_name")
    public abstract String getName();

    @Json(name="over18")
    @Deprecated
    @Nullable
    public abstract Boolean getNsfw();

    @Json(name="over18")
    public final boolean isNsfw() {
        return this.getNsfw() != null && this.getNsfw() != false;
    }

    @Json(name="public_description")
    public abstract String getPublicDescription();

    @Json(name="quarantine")
    @Nullable
    abstract Boolean getQuarantined();

    @Json(name="quarantine")
    public final boolean isQuarantined() {
        return this.getQuarantined() != null && this.getQuarantined() != false;
    }

    @Json(name="description")
    @Nullable
    public abstract String getSidebar();

    @Json(name="spoilers_enabled")
    @Nullable
    abstract Boolean getSpoilersEnabled();

    public final boolean isSpoilersEnabled() {
        return this.getSpoilersEnabled() != null && this.getSpoilersEnabled() != false;
    }

    @Json(name="submission_type")
    @Nullable
    public abstract SubmissionType getSubmissionType();

    @Json(name="submit_link_label")
    @Nullable
    public abstract String getSubmitLinkLabel();

    @Json(name="submit_text_label")
    @Nullable
    public abstract String getSubmitTextLabel();

    @Json(name="subscribers")
    @Nullable
    abstract Integer getSubscribersNullable();

    public final int getSubscribers() {
        return this.getSubscribersNullable() == null ? -1 : this.getSubscribersNullable();
    }

    @Json(name="suggested_comment_sort")
    @Nullable
    public abstract CommentSort getSuggestedCommentSort();

    public abstract String getTitle();

    @Override
    @NotNull
    public String getUniqueId() {
        return this.getFullName();
    }

    public abstract String getUrl();

    @Json(name="user_is_muted")
    @Nullable
    abstract Boolean getUserIsMuted();

    @Json(name="user_is_banned")
    @Nullable
    abstract Boolean getUserIsBanned();

    @Json(name="user_is_contributor")
    @Nullable
    abstract Boolean getUserIsContributor();

    @Json(name="user_is_moderator")
    @Nullable
    abstract Boolean getUserIsModerator();

    @Json(name="user_is_subscriber")
    @Nullable
    abstract Boolean getUserIsSubscriber();

    @Json(name="user_flair_text")
    @Nullable
    public abstract String getUserFlairText();

    @Json(name="user_flair_enabled_in_sr")
    @Nullable
    abstract Boolean getUserFlairGenerallyEnabled();

    public final boolean isUserFlairGenerallyEnabled() {
        return this.getUserFlairGenerallyEnabled() != null && this.getUserFlairGenerallyEnabled() != false;
    }

    @Json(name="user_sr_flair_enabled")
    @Nullable
    abstract Boolean getUserFlairEnabled();

    public final boolean isFlairEnabledForUser() {
        return this.getUserFlairEnabled() != null && this.getUserFlairEnabled() != false;
    }

    public final boolean isUserMuted() {
        return this.getUserIsMuted() != null && this.getUserIsMuted() != false;
    }

    public final boolean isUserBanned() {
        return this.getUserIsBanned() != null && this.getUserIsBanned() != false;
    }

    public final boolean isUserContributor() {
        return this.getUserIsContributor() != null && this.getUserIsContributor() != false;
    }

    public final boolean isUserModerator() {
        return this.getUserIsModerator() != null && this.getUserIsModerator() != false;
    }

    public final boolean isUserSubscriber() {
        return this.getUserIsSubscriber() != null && this.getUserIsSubscriber() != false;
    }

    @Override
    @NotNull
    public SubredditReference toReference(@NotNull RedditClient reddit) {
        return reddit.subreddit(this.getName());
    }

    public static JsonAdapter<Subreddit> jsonAdapter(Moshi moshi) {
        return new AutoValue_Subreddit.MoshiJsonAdapter(moshi);
    }

    public static enum Access {
        PUBLIC,
        PRIVATE,
        RESTRICTED,
        GOLD_RESTRICTED,
        ARCHIVED,
        USER;

    }

    public static enum SubmissionType {
        ANY,
        LINK,
        SELF,
        NONE;

    }
}

