/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.models.internal;

import com.google.auto.value.AutoValue;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.dean.jraw.ApiException;
import net.dean.jraw.RateLimitException;
import net.dean.jraw.RedditException;
import net.dean.jraw.http.NetworkException;
import net.dean.jraw.models.internal.AutoValue_GenericJsonResponse;
import net.dean.jraw.models.internal.RedditExceptionStub;
import org.jetbrains.annotations.Nullable;

@AutoValue
public abstract class GenericJsonResponse
implements RedditExceptionStub<RedditException> {
    @Nullable
    public abstract Inner getJson();

    @Override
    @Nullable
    public RedditException create(NetworkException cause) {
        if (this.getJson() == null) {
            return null;
        }
        if (this.getJson().ratelimit != null) {
            return new RateLimitException(this.getJson().ratelimit, cause);
        }
        if (this.getJson().errors != null && !this.getJson().errors.isEmpty()) {
            List<String> error = this.getJson().errors.get(0);
            String relevantParameter = error.size() > 2 ? error.get(2) : null;
            return new ApiException(error.get(0), error.get(1), Collections.singletonList(relevantParameter), cause);
        }
        return null;
    }

    @Override
    public boolean containsError() {
        return this.getJson() != null && (this.getJson().ratelimit != null || !this.getJson().errors.isEmpty());
    }

    public String toString() {
        return "GenericJsonResponse{getJson()=" + this.getJson() + '}';
    }

    public static JsonAdapter<GenericJsonResponse> jsonAdapter(Moshi moshi) {
        return new AutoValue_GenericJsonResponse.MoshiJsonAdapter(moshi);
    }

    public static final class Inner {
        public List<List<String>> errors;
        public Map<String, Object> data;
        @Nullable
        public Double ratelimit;

        public String toString() {
            return "Inner{errors=" + this.errors + ", data=" + this.data + ", ratelimit=" + this.ratelimit + '}';
        }
    }
}

