/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.models.internal;

import com.google.auto.value.AutoValue;
import com.squareup.moshi.Json;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import net.dean.jraw.models.OAuthData;
import net.dean.jraw.models.internal.AutoValue_OAuthDataJson;
import org.jetbrains.annotations.Nullable;

@AutoValue
public abstract class OAuthDataJson {
    @Json(name="access_token")
    public abstract String getAccessToken();

    @Json(name="expires_in")
    public abstract long getExpiresIn();

    @Json(name="scope")
    public abstract String getScopeList();

    @Json(name="refresh_token")
    @Nullable
    public abstract String getRefreshToken();

    public final OAuthData toOAuthData() {
        return OAuthData.create(this.getAccessToken(), Arrays.asList(this.getScopeList().split(" ")), this.getRefreshToken(), new Date(new Date().getTime() + TimeUnit.MILLISECONDS.convert(this.getExpiresIn(), TimeUnit.SECONDS)));
    }

    public static JsonAdapter<OAuthDataJson> jsonAdapter(Moshi moshi) {
        return new AutoValue_OAuthDataJson.MoshiJsonAdapter(moshi);
    }
}

