/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.models.internal;

import com.google.auto.value.AutoValue;
import com.squareup.moshi.Json;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.util.ArrayList;
import java.util.List;
import net.dean.jraw.ApiException;
import net.dean.jraw.http.NetworkException;
import net.dean.jraw.models.internal.AutoValue_ObjectBasedApiExceptionStub;
import net.dean.jraw.models.internal.RedditExceptionStub;
import org.jetbrains.annotations.Nullable;

@AutoValue
public abstract class ObjectBasedApiExceptionStub
implements RedditExceptionStub<ApiException> {
    @Json(name="fields")
    @Nullable
    public abstract List<String> getRelevantFields();

    @Nullable
    public abstract String getExplanation();

    @Nullable
    public abstract String getMessage();

    @Json(name="reason")
    @Nullable
    public abstract String getCode();

    @Json(name="error")
    @Nullable
    public abstract Integer getHttpStatusCode();

    @Override
    @Nullable
    public final ApiException create(NetworkException cause) {
        if (this.getRelevantFields() != null && this.getExplanation() != null && this.getMessage() != null && this.getCode() != null) {
            return new ApiException(this.getCode(), this.getExplanation(), this.getRelevantFields(), cause);
        }
        if (this.getMessage() != null && this.getHttpStatusCode() != null) {
            return new ApiException(this.getHttpStatusCode().toString(), this.getMessage(), new ArrayList<String>(), cause);
        }
        return null;
    }

    @Override
    public boolean containsError() {
        return this.getMessage() != null;
    }

    public static JsonAdapter<ObjectBasedApiExceptionStub> jsonAdapter(Moshi moshi) {
        return new AutoValue_ObjectBasedApiExceptionStub.MoshiJsonAdapter(moshi);
    }
}

