/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.oauth;

import java.util.Date;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.dean.jraw.RedditClient;
import net.dean.jraw.http.NetworkAdapter;
import net.dean.jraw.models.OAuthData;
import net.dean.jraw.oauth.AccountHelper;
import net.dean.jraw.oauth.AuthManager;
import net.dean.jraw.oauth.AuthMethod;
import net.dean.jraw.oauth.Credentials;
import net.dean.jraw.oauth.OAuthHelper;
import net.dean.jraw.oauth.StatefulAuthHelper;
import net.dean.jraw.oauth.TokenStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0006\u0010\u001c\u001a\u00020\u0018J\u0006\u0010\u001d\u001a\u00020\u0012J)\u0010\u001e\u001a\u00020\u00122!\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\u000eJ\u001a\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\f2\b\b\u0002\u0010!\u001a\u00020\u0018H\u0002J\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020&H\u0007J\u0006\u0010'\u001a\u00020\fJ\u0010\u0010(\u001a\u0004\u0018\u00010\f2\u0006\u0010%\u001a\u00020&J\u001c\u0010(\u001a\u0004\u0018\u00010\f2\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0002R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R)\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lnet/dean/jraw/oauth/AccountHelper;", "", "http", "Lnet/dean/jraw/http/NetworkAdapter;", "creds", "Lnet/dean/jraw/oauth/Credentials;", "tokenStore", "Lnet/dean/jraw/oauth/TokenStore;", "deviceId", "Ljava/util/UUID;", "(Lnet/dean/jraw/http/NetworkAdapter;Lnet/dean/jraw/oauth/Credentials;Lnet/dean/jraw/oauth/TokenStore;Ljava/util/UUID;)V", "_reddit", "Lnet/dean/jraw/RedditClient;", "configure", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "r", "", "reddit", "getReddit", "()Lnet/dean/jraw/RedditClient;", "userlessCreds", "equals", "", "other", "hashCode", "", "isAuthenticated", "logout", "onSwitch", "switch", "new", "forceRenew", "switchToNewUser", "Lnet/dean/jraw/oauth/StatefulAuthHelper;", "switchToUser", "username", "", "switchToUserless", "trySwitchToUser", "lib"})
public final class AccountHelper {
    private RedditClient _reddit;
    private Function1<? super RedditClient, Unit> configure;
    private final Credentials userlessCreds;
    private final NetworkAdapter http;
    private final Credentials creds;
    private final TokenStore tokenStore;

    @NotNull
    public final RedditClient getReddit() {
        RedditClient redditClient = this._reddit;
        if (redditClient == null) {
            throw (Throwable)new IllegalStateException("No current authenticated client");
        }
        return redditClient;
    }

    @NotNull
    public final RedditClient switchToUserless() {
        RedditClient seamless = this.trySwitchToUser("<userless>", this.userlessCreds);
        if (seamless != null) {
            return seamless;
        }
        return AccountHelper.switch$default(this, OAuthHelper.automatic(this.http, this.userlessCreds, this.tokenStore), false, 2, null);
    }

    @NotNull
    public final RedditClient switchToUser(@NotNull String username) throws IllegalStateException {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        RedditClient redditClient = this.trySwitchToUser(username);
        if (redditClient == null) {
            throw (Throwable)new IllegalStateException("No unexpired OAuthData or refresh token available for user '" + username + '\'');
        }
        return redditClient;
    }

    @Nullable
    public final RedditClient trySwitchToUser(@NotNull String username) {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        return this.trySwitchToUser(username, this.creds);
    }

    private final RedditClient trySwitchToUser(String username, Credentials creds) {
        OAuthData current2 = this.tokenStore.fetchLatest(username);
        if (current2 != null && !current2.isExpired()) {
            return AccountHelper.switch$default(this, new RedditClient(this.http, current2, creds, this.tokenStore, username), false, 2, null);
        }
        String refresh = this.tokenStore.fetchRefreshToken(username);
        if (refresh != null) {
            OAuthData emptyData;
            String string = "";
            List list = CollectionsKt.emptyList();
            OAuthData oAuthData = emptyData = OAuthData.create(string, list, refresh, new Date(0L));
            Intrinsics.checkExpressionValueIsNotNull((Object)oAuthData, (String)"emptyData");
            return this.switch(new RedditClient(this.http, oAuthData, creds, this.tokenStore, username), true);
        }
        return null;
    }

    static /* bridge */ /* synthetic */ RedditClient trySwitchToUser$default(AccountHelper accountHelper, String string, Credentials credentials, int n, Object object) {
        if ((n & 2) != 0) {
            credentials = accountHelper.creds;
        }
        return accountHelper.trySwitchToUser(string, credentials);
    }

    @NotNull
    public final StatefulAuthHelper switchToNewUser() {
        return OAuthHelper.interactive$lib(this.http, this.creds, this.tokenStore, (Function1<? super RedditClient, Unit>)((Function1)new Function1<RedditClient, Unit>(this){
            final /* synthetic */ AccountHelper this$0;

            public final void invoke(@NotNull RedditClient newClient) {
                Intrinsics.checkParameterIsNotNull((Object)newClient, (String)"newClient");
                AccountHelper.switch$default(this.this$0, newClient, false, 2, null);
            }
            {
                this.this$0 = accountHelper;
                super(1);
            }
        }));
    }

    public final boolean isAuthenticated() {
        Object object = this._reddit;
        if (object == null || (object = ((RedditClient)object).getAuthManager()) == null) {
            return false;
        }
        Object authManager = object;
        RedditClient redditClient = this._reddit;
        if (redditClient == null) {
            Intrinsics.throwNpe();
        }
        return !redditClient.getLoggedOut$lib() && (!((AuthManager)authManager).needsRenewing() || ((AuthManager)authManager).canRenew());
    }

    public final void logout() {
        RedditClient redditClient = this._reddit;
        if (redditClient == null) {
            return;
        }
        RedditClient r = redditClient;
        r.setLoggedOut$lib(true);
        this._reddit = null;
    }

    public final void onSwitch(@NotNull Function1<? super RedditClient, Unit> configure2) {
        Intrinsics.checkParameterIsNotNull(configure2, (String)"configure");
        this.configure = configure2;
    }

    private final RedditClient switch(RedditClient redditClient, boolean forceRenew) {
        RedditClient redditClient2 = this._reddit;
        if (redditClient2 != null) {
            redditClient2.setLoggedOut$lib(true);
        }
        redditClient.setForceRenew$lib(forceRenew);
        this.configure.invoke((Object)redditClient);
        this._reddit = redditClient;
        return redditClient;
    }

    static /* bridge */ /* synthetic */ RedditClient switch$default(AccountHelper accountHelper, RedditClient redditClient, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return accountHelper.switch(redditClient, bl);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.dean.jraw.oauth.AccountHelper");
        }
        AccountHelper cfr_ignored_0 = (AccountHelper)object2;
        if (Intrinsics.areEqual((Object)this.http, (Object)((AccountHelper)other).http) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.creds, (Object)((AccountHelper)other).creds) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.tokenStore, (Object)((AccountHelper)other).tokenStore) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this._reddit, (Object)((AccountHelper)other)._reddit) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.userlessCreds, (Object)((AccountHelper)other).userlessCreds) ^ true);
    }

    public int hashCode() {
        int result = this.http.hashCode();
        result = 31 * result + this.creds.hashCode();
        result = 31 * result + this.tokenStore.hashCode();
        RedditClient redditClient = this._reddit;
        result = 31 * result + (redditClient != null ? redditClient.hashCode() : 0);
        result = 31 * result + this.userlessCreds.hashCode();
        return result;
    }

    public AccountHelper(@NotNull NetworkAdapter http, @NotNull Credentials creds, @NotNull TokenStore tokenStore, @NotNull UUID deviceId) {
        Intrinsics.checkParameterIsNotNull((Object)http, (String)"http");
        Intrinsics.checkParameterIsNotNull((Object)creds, (String)"creds");
        Intrinsics.checkParameterIsNotNull((Object)tokenStore, (String)"tokenStore");
        Intrinsics.checkParameterIsNotNull((Object)deviceId, (String)"deviceId");
        this.http = http;
        this.creds = creds;
        this.tokenStore = tokenStore;
        if (this.creds.getAuthMethod().isUserless() || this.creds.getAuthMethod() == AuthMethod.SCRIPT) {
            throw (Throwable)new IllegalArgumentException("AccountManager cannot be used with userless or script credentials");
        }
        this.configure = configure.1.INSTANCE;
        this.userlessCreds = this.creds.getAuthMethod() == AuthMethod.APP ? Credentials.Companion.userlessApp(this.creds.getClientId(), deviceId) : Credentials.Companion.userless(this.creds.getClientId(), this.creds.getClientSecret(), deviceId);
    }
}

