/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.oauth;

import com.squareup.moshi.JsonAdapter;
import java.io.Serializable;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dean.jraw.JrawUtils;
import net.dean.jraw.http.HttpRequest;
import net.dean.jraw.http.HttpResponse;
import net.dean.jraw.http.NetworkAdapter;
import net.dean.jraw.http.NetworkException;
import net.dean.jraw.models.OAuthData;
import net.dean.jraw.models.internal.OAuthDataJson;
import net.dean.jraw.oauth.AuthMethod;
import net.dean.jraw.oauth.Credentials;
import net.dean.jraw.oauth.NoopTokenStore;
import net.dean.jraw.oauth.OAuthException;
import net.dean.jraw.oauth.OAuthHelper;
import net.dean.jraw.oauth.TokenPersistenceStrategy;
import net.dean.jraw.oauth.TokenStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 82\u00020\u0001:\u00018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010'\u001a\u00020(J\u0006\u0010\u0015\u001a\u00020\nJ\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0006\u0010-\u001a\u00020(J\u0006\u0010.\u001a\u00020*J\u0006\u0010/\u001a\u00020*J\u0006\u00100\u001a\u00020*J\u001a\u00101\u001a\u00020*2\u0006\u00102\u001a\u00020\n2\b\u00103\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u00104\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u0017\u00105\u001a\u00020*2\b\u00106\u001a\u0004\u0018\u00010\bH\u0000\u00a2\u0006\u0002\b7R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\r\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\rR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u00069"}, d2={"Lnet/dean/jraw/oauth/AuthManager;", "", "http", "Lnet/dean/jraw/http/NetworkAdapter;", "credentials", "Lnet/dean/jraw/oauth/Credentials;", "(Lnet/dean/jraw/http/NetworkAdapter;Lnet/dean/jraw/oauth/Credentials;)V", "_current", "Lnet/dean/jraw/models/OAuthData;", "_refreshToken", "", "accessToken", "getAccessToken", "()Ljava/lang/String;", "authMethod", "Lnet/dean/jraw/oauth/AuthMethod;", "getAuthMethod$lib", "()Lnet/dean/jraw/oauth/AuthMethod;", "current", "getCurrent", "()Lnet/dean/jraw/models/OAuthData;", "currentUsername", "getCurrentUsername$lib", "setCurrentUsername$lib", "(Ljava/lang/String;)V", "refreshToken", "getRefreshToken", "tokenPersistenceStrategy", "Lnet/dean/jraw/oauth/TokenPersistenceStrategy;", "getTokenPersistenceStrategy", "()Lnet/dean/jraw/oauth/TokenPersistenceStrategy;", "setTokenPersistenceStrategy", "(Lnet/dean/jraw/oauth/TokenPersistenceStrategy;)V", "tokenStore", "Lnet/dean/jraw/oauth/TokenStore;", "getTokenStore", "()Lnet/dean/jraw/oauth/TokenStore;", "setTokenStore", "(Lnet/dean/jraw/oauth/TokenStore;)V", "canRenew", "", "handleUnsuccessfulOAuthRequests", "", "res", "Lnet/dean/jraw/http/HttpResponse;", "needsRenewing", "renew", "revokeAccessToken", "revokeRefreshToken", "revokeToken", "typeHint", "token", "sendRenewalRequest", "update", "newData", "update$lib", "Companion", "lib"})
public final class AuthManager {
    private OAuthData _current;
    @Nullable
    private String currentUsername;
    @NotNull
    private TokenStore tokenStore;
    @NotNull
    private TokenPersistenceStrategy tokenPersistenceStrategy;
    private String _refreshToken;
    @NotNull
    private final AuthMethod authMethod;
    private final NetworkAdapter http;
    private final Credentials credentials;
    @NotNull
    public static final String USERNAME_USERLESS = "<userless>";
    @NotNull
    public static final String USERNAME_UNKOWN = "<unknown>";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final OAuthData getCurrent() {
        return this._current;
    }

    @Nullable
    public final String getCurrentUsername$lib() {
        return this.currentUsername;
    }

    public final void setCurrentUsername$lib(@Nullable String string) {
        this.currentUsername = string;
    }

    @NotNull
    public final TokenStore getTokenStore() {
        return this.tokenStore;
    }

    public final void setTokenStore(@NotNull TokenStore tokenStore) {
        Intrinsics.checkParameterIsNotNull((Object)tokenStore, (String)"<set-?>");
        this.tokenStore = tokenStore;
    }

    @NotNull
    public final TokenPersistenceStrategy getTokenPersistenceStrategy() {
        return this.tokenPersistenceStrategy;
    }

    public final void setTokenPersistenceStrategy(@NotNull TokenPersistenceStrategy tokenPersistenceStrategy) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)tokenPersistenceStrategy), (String)"<set-?>");
        this.tokenPersistenceStrategy = tokenPersistenceStrategy;
    }

    @Nullable
    public final String getRefreshToken() {
        return this._refreshToken;
    }

    @NotNull
    public final String getAccessToken() {
        OAuthData oAuthData = this.getCurrent();
        if (oAuthData == null) {
            throw (Throwable)new IllegalStateException("No current OAuthData");
        }
        String string = oAuthData.getAccessToken();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(current ?: throw Illega\u2026 OAuthData\")).accessToken");
        return string;
    }

    @NotNull
    public final AuthMethod getAuthMethod$lib() {
        return this.authMethod;
    }

    public final void renew() {
        OAuthData oAuthData;
        if (this.authMethod == AuthMethod.SCRIPT) {
            oAuthData = OAuthHelper.scriptOAuthData$lib(this.http, this.credentials);
        } else if (this.authMethod.isUserless()) {
            oAuthData = OAuthHelper.applicationOnlyOAuthData$lib(this.http, this.credentials);
        } else if (this._refreshToken != null) {
            String string = this._refreshToken;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            oAuthData = this.sendRenewalRequest(string);
        } else {
            throw (Throwable)new IllegalStateException("Cannot refresh current OAuthData (no refresh token or not a script app)");
        }
        OAuthData newData = oAuthData;
        this.update$lib(newData);
    }

    public final boolean needsRenewing() {
        Serializable serializable = this._current;
        if (serializable == null || (serializable = ((OAuthData)serializable).getExpiration()) == null) {
            return true;
        }
        return ((Date)serializable).before(new Date());
    }

    public final boolean canRenew() {
        return this.credentials.getAuthMethod() == AuthMethod.SCRIPT || this.credentials.getAuthMethod().isUserless() ? true : this._refreshToken != null;
    }

    public final void update$lib(@Nullable OAuthData newData) {
        if (newData != null) {
            if (this._refreshToken == null && newData.getRefreshToken() != null) {
                this._refreshToken = newData.getRefreshToken();
                if (this.tokenPersistenceStrategy == TokenPersistenceStrategy.REFRESH_ONLY || this.tokenPersistenceStrategy == TokenPersistenceStrategy.ALL) {
                    String string = this.currentUsername();
                    String string2 = this._refreshToken;
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.tokenStore.storeRefreshToken(string, string2);
                }
            }
            if (this.tokenPersistenceStrategy == TokenPersistenceStrategy.ALL) {
                this.tokenStore.storeLatest(this.currentUsername(), newData);
            }
            this._current = newData;
        }
    }

    private final OAuthData sendRenewalRequest(String refreshToken) {
        HttpResponse this_$iv;
        HttpResponse res2 = this.http.execute(new HttpRequest.Builder().url("https://www.reddit.com/api/v1/access_token").post(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"grant_type", (Object)"refresh_token"), TuplesKt.to((Object)"refresh_token", (Object)refreshToken)})).basicAuth((Pair<String, String>)TuplesKt.to((Object)this.credentials.getClientId(), (Object)this.credentials.getClientSecret())).build());
        this.handleUnsuccessfulOAuthRequests(res2);
        HttpResponse httpResponse = this_$iv = res2;
        JsonAdapter jsonAdapter = JrawUtils.moshi.adapter(OAuthDataJson.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"moshi.adapter(T::class.java)");
        JsonAdapter jsonAdapter2 = jsonAdapter;
        OAuthData oAuthData = ((OAuthDataJson)httpResponse.deserializeWith(jsonAdapter2)).toOAuthData();
        Intrinsics.checkExpressionValueIsNotNull((Object)oAuthData, (String)"res.deserialize<OAuthDataJson>().toOAuthData()");
        return oAuthData;
    }

    public final void revokeAccessToken() {
        OAuthData oAuthData = this.getCurrent();
        this.revokeToken("access_token", oAuthData != null ? oAuthData.getAccessToken() : null);
        this._current = null;
        this.tokenStore.deleteLatest(this.currentUsername());
    }

    public final void revokeRefreshToken() {
        this.revokeToken("refresh_token", this.getRefreshToken());
        this._refreshToken = null;
        this.tokenStore.deleteRefreshToken(this.currentUsername());
    }

    private final void revokeToken(String typeHint, String token) {
        if (token == null) {
            return;
        }
        HttpResponse res2 = this.http.execute(new HttpRequest.Builder().url("https://www.reddit.com/api/v1/revoke_token").post(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"token", (Object)token), TuplesKt.to((Object)"token_type_hint", (Object)typeHint)})).basicAuth((Pair<String, String>)TuplesKt.to((Object)this.credentials.getClientId(), (Object)this.credentials.getClientSecret())).build());
        this.handleUnsuccessfulOAuthRequests(res2);
    }

    private final void handleUnsuccessfulOAuthRequests(HttpResponse res2) {
        if (!res2.getSuccessful()) {
            NetworkException e = new NetworkException(res2);
            if (res2.getCode() == 401) {
                throw (Throwable)new OAuthException("Incorrect client ID and/or client secret", e);
            }
            throw (Throwable)e;
        }
    }

    @NotNull
    public final String currentUsername() {
        String string;
        if (this.credentials.getAuthMethod().isUserless()) {
            string = USERNAME_USERLESS;
        } else {
            string = this.currentUsername;
            if (string == null) {
                string = USERNAME_UNKOWN;
            }
        }
        return string;
    }

    public AuthManager(@NotNull NetworkAdapter http, @NotNull Credentials credentials) {
        Intrinsics.checkParameterIsNotNull((Object)http, (String)"http");
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        this.http = http;
        this.credentials = credentials;
        this.tokenStore = new NoopTokenStore();
        this.tokenPersistenceStrategy = TokenPersistenceStrategy.ALL;
        this.authMethod = this.credentials.getAuthMethod();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/dean/jraw/oauth/AuthManager$Companion;", "", "()V", "USERNAME_UNKOWN", "", "USERNAME_USERLESS", "lib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

