/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.oauth;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dean.jraw.Extensions;
import net.dean.jraw.models.OAuthData;
import net.dean.jraw.models.PersistedAuthData;
import net.dean.jraw.oauth.TokenStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010%\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u001d\b\u0007\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0004H\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0004H\u0016J\u0014\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H$J\u001c\u0010\u001b\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H$J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0018\u001a\u00020\u0004J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u0004J\u0006\u0010\u001f\u001a\u00020\bJ\u0010\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u0004J\u0006\u0010!\u001a\u00020\u0015J\u0006\u0010\"\u001a\u00020\u0015J\u0006\u0010#\u001a\u00020$J\u0016\u0010%\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u001dJ\u0016\u0010&\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u0004R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006("}, d2={"Lnet/dean/jraw/oauth/DeferredPersistentTokenStore;", "Lnet/dean/jraw/oauth/TokenStore;", "initialData", "", "", "Lnet/dean/jraw/models/PersistedAuthData;", "(Ljava/util/Map;)V", "autoPersist", "", "getAutoPersist", "()Z", "setAutoPersist", "(Z)V", "lastPersistedData", "memoryData", "", "usernames", "", "getUsernames", "()Ljava/util/List;", "clear", "", "data", "deleteLatest", "username", "deleteRefreshToken", "doLoad", "doPersist", "fetchLatest", "Lnet/dean/jraw/models/OAuthData;", "fetchRefreshToken", "hasUnsaved", "inspect", "load", "persist", "size", "", "storeLatest", "storeRefreshToken", "token", "lib"})
public abstract class DeferredPersistentTokenStore
implements TokenStore {
    private Map<String, PersistedAuthData> memoryData;
    private Map<String, ? extends PersistedAuthData> lastPersistedData;
    private boolean autoPersist;

    public final boolean getAutoPersist() {
        return this.autoPersist;
    }

    public final void setAutoPersist(boolean bl) {
        this.autoPersist = bl;
    }

    @Nullable
    public final PersistedAuthData inspect(@NotNull String username) {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        return this.memoryData.get(username);
    }

    @NotNull
    public final List<String> getUsernames() {
        return CollectionsKt.toList((Iterable)this.memoryData.keySet());
    }

    public final boolean hasUnsaved() {
        return Intrinsics.areEqual(this.lastPersistedData, this.memoryData) ^ true;
    }

    /*
     * WARNING - void declaration
     */
    public final void persist() {
        void $receiver$iv$iv;
        Map<String, PersistedAuthData> $receiver$iv = this.memoryData;
        Map<String, PersistedAuthData> map = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map3 = map2;
            PersistedAuthData persistedAuthData = ((PersistedAuthData)it.getValue()).simplify();
            map3.put(k2, persistedAuthData);
        }
        Map actualData = Extensions.filterValuesNotNull(destination$iv$iv);
        this.doPersist(actualData);
        Unit result = Unit.INSTANCE;
        this.lastPersistedData = new HashMap<String, PersistedAuthData>(this.memoryData);
    }

    /*
     * WARNING - void declaration
     */
    public final void load() {
        Map map;
        void $receiver$iv$iv;
        void $receiver$iv;
        Map<String, PersistedAuthData> map2 = this.doLoad();
        DeferredPersistentTokenStore deferredPersistentTokenStore = this;
        void var2_3 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            map = map3;
            PersistedAuthData persistedAuthData = ((PersistedAuthData)it.getValue()).simplify();
            map.put(k2, persistedAuthData);
        }
        map = destination$iv$iv;
        deferredPersistentTokenStore.memoryData = MapsKt.toMutableMap(Extensions.filterValuesNotNull(map));
    }

    public final void clear() {
        this.memoryData.clear();
    }

    public final int size() {
        return this.memoryData.size();
    }

    protected abstract void doPersist(@NotNull Map<String, ? extends PersistedAuthData> var1);

    @NotNull
    protected abstract Map<String, PersistedAuthData> doLoad();

    @NotNull
    public final Map<String, PersistedAuthData> data() {
        return new HashMap<String, PersistedAuthData>(this.memoryData);
    }

    @Override
    public final void storeLatest(@NotNull String username, @NotNull OAuthData data2) {
        PersistedAuthData stored;
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
        if (Intrinsics.areEqual((Object)username, (Object)"<unknown>")) {
            throw (Throwable)new IllegalArgumentException("Refusing to store data for unknown username");
        }
        PersistedAuthData persistedAuthData = stored = this.memoryData.get(username);
        PersistedAuthData persistedAuthData2 = PersistedAuthData.create(data2, persistedAuthData != null ? persistedAuthData.getRefreshToken() : null);
        Map<String, PersistedAuthData> map = this.memoryData;
        PersistedAuthData persistedAuthData3 = persistedAuthData2;
        Intrinsics.checkExpressionValueIsNotNull((Object)persistedAuthData3, (String)"new");
        PersistedAuthData persistedAuthData4 = persistedAuthData3;
        map.put(username, persistedAuthData4);
        if (this.autoPersist && this.hasUnsaved()) {
            this.persist();
        }
    }

    @Override
    public final void storeRefreshToken(@NotNull String username, @NotNull String token) {
        PersistedAuthData stored;
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        if (Intrinsics.areEqual((Object)username, (Object)"<unknown>")) {
            throw (Throwable)new IllegalArgumentException("Refusing to store data for unknown username");
        }
        PersistedAuthData persistedAuthData = stored = this.memoryData.get(username);
        PersistedAuthData persistedAuthData2 = PersistedAuthData.create(persistedAuthData != null ? persistedAuthData.getLatest() : null, token);
        Map<String, PersistedAuthData> map = this.memoryData;
        PersistedAuthData persistedAuthData3 = persistedAuthData2;
        Intrinsics.checkExpressionValueIsNotNull((Object)persistedAuthData3, (String)"new");
        PersistedAuthData persistedAuthData4 = persistedAuthData3;
        map.put(username, persistedAuthData4);
        if (this.autoPersist && this.hasUnsaved()) {
            this.persist();
        }
    }

    @Override
    @Nullable
    public final OAuthData fetchLatest(@NotNull String username) {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        PersistedAuthData persistedAuthData = this.memoryData.get(username);
        return persistedAuthData != null ? persistedAuthData.getLatest() : null;
    }

    @Override
    @Nullable
    public final String fetchRefreshToken(@NotNull String username) {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        PersistedAuthData persistedAuthData = this.memoryData.get(username);
        return persistedAuthData != null ? persistedAuthData.getRefreshToken() : null;
    }

    @Override
    public void deleteLatest(@NotNull String username) {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        PersistedAuthData persistedAuthData = this.memoryData.get(username);
        if (persistedAuthData == null) {
            return;
        }
        PersistedAuthData saved = persistedAuthData;
        if (saved.getRefreshToken() == null) {
            this.memoryData.remove(username);
        } else {
            Map<String, PersistedAuthData> map = this.memoryData;
            PersistedAuthData persistedAuthData2 = PersistedAuthData.create(null, saved.getRefreshToken());
            Intrinsics.checkExpressionValueIsNotNull((Object)persistedAuthData2, (String)"PersistedAuthData.create(null, saved.refreshToken)");
            PersistedAuthData persistedAuthData3 = persistedAuthData2;
            map.put(username, persistedAuthData3);
        }
        if (this.autoPersist && this.hasUnsaved()) {
            this.persist();
        }
    }

    @Override
    public void deleteRefreshToken(@NotNull String username) {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        PersistedAuthData persistedAuthData = this.memoryData.get(username);
        if (persistedAuthData == null) {
            return;
        }
        PersistedAuthData saved = persistedAuthData;
        if (saved.getLatest() == null) {
            this.memoryData.remove(username);
        } else {
            Map<String, PersistedAuthData> map = this.memoryData;
            PersistedAuthData persistedAuthData2 = PersistedAuthData.create(saved.getLatest(), null);
            Intrinsics.checkExpressionValueIsNotNull((Object)persistedAuthData2, (String)"PersistedAuthData.create(saved.latest, null)");
            PersistedAuthData persistedAuthData3 = persistedAuthData2;
            map.put(username, persistedAuthData3);
        }
        if (this.autoPersist && this.hasUnsaved()) {
            this.persist();
        }
    }

    @JvmOverloads
    public DeferredPersistentTokenStore(@NotNull Map<String, ? extends PersistedAuthData> initialData) {
        Intrinsics.checkParameterIsNotNull(initialData, (String)"initialData");
        this.memoryData = MapsKt.toMutableMap(initialData);
    }

    @JvmOverloads
    public /* synthetic */ DeferredPersistentTokenStore(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        this(map);
    }

    @JvmOverloads
    public DeferredPersistentTokenStore() {
        this(null, 1, null);
    }
}

