/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.oauth;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Types;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dean.jraw.JrawUtils;
import net.dean.jraw.models.PersistedAuthData;
import net.dean.jraw.oauth.DeferredPersistentTokenStore;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0014J\u001c\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0015J\u0010\u0010\u0011\u001a\u00020\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\u0006Rb\u0010\t\u001aV\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007 \u000b*\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00050\u0005 \u000b**\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007 \u000b*\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00050\u0005\u0018\u00010\n0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lnet/dean/jraw/oauth/JsonFileTokenStore;", "Lnet/dean/jraw/oauth/DeferredPersistentTokenStore;", "saveLocation", "Ljava/io/File;", "initialData", "", "", "Lnet/dean/jraw/models/PersistedAuthData;", "(Ljava/io/File;Ljava/util/Map;)V", "adapter", "Lcom/squareup/moshi/JsonAdapter;", "kotlin.jvm.PlatformType", "baseAdapter", "doLoad", "doPersist", "", "data", "indent", "with", "Companion", "lib"})
public final class JsonFileTokenStore
extends DeferredPersistentTokenStore {
    private final JsonAdapter<Map<String, PersistedAuthData>> baseAdapter;
    private JsonAdapter<Map<String, PersistedAuthData>> adapter;
    private final File saveLocation;
    private static final ParameterizedType ADAPTER_TYPE;
    public static final Companion Companion;

    @NotNull
    public final JsonFileTokenStore indent(@Nullable String with) {
        String string = with;
        if (string == null) {
            string = "";
        }
        String indent = string;
        this.adapter = this.baseAdapter.indent(indent);
        return this;
    }

    @Override
    protected void doPersist(@NotNull Map<String, ? extends PersistedAuthData> data2) throws IOException {
        Intrinsics.checkParameterIsNotNull(data2, (String)"data");
        if (!this.saveLocation.exists() && this.saveLocation.getAbsoluteFile().getParentFile() != null) {
            File parent;
            File file = this.saveLocation.getAbsoluteFile().getParentFile();
            if (file == null) {
                Intrinsics.throwNpe();
            }
            if (!(parent = file).exists() && !parent.mkdirs()) {
                throw (Throwable)new IOException("Unable to create parent directory " + parent);
            }
        }
        BufferedSink sink = Okio.buffer((Sink)Okio.sink((File)this.saveLocation));
        this.adapter.toJson(sink, data2);
        sink.close();
    }

    @Override
    @NotNull
    protected Map<String, PersistedAuthData> doLoad() {
        if (!this.saveLocation.isFile()) {
            throw (Throwable)new FileNotFoundException("Not a file or doesn't exist: " + this.saveLocation.getAbsolutePath());
        }
        Object object = this.adapter.fromJson(Okio.buffer((Source)Okio.source((File)this.saveLocation)));
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (Map)object;
    }

    @JvmOverloads
    public JsonFileTokenStore(@NotNull File saveLocation, @NotNull Map<String, ? extends PersistedAuthData> initialData) {
        Intrinsics.checkParameterIsNotNull((Object)saveLocation, (String)"saveLocation");
        Intrinsics.checkParameterIsNotNull(initialData, (String)"initialData");
        super(initialData);
        this.saveLocation = saveLocation;
        JsonAdapter jsonAdapter = JrawUtils.moshi.adapter((Type)ADAPTER_TYPE);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"JrawUtils.moshi.adapter<\u2026dAuthData>>(ADAPTER_TYPE)");
        this.baseAdapter = jsonAdapter;
        this.adapter = this.baseAdapter.indent("");
    }

    @JvmOverloads
    public /* synthetic */ JsonFileTokenStore(File file, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        this(file, map);
    }

    @JvmOverloads
    public JsonFileTokenStore(@NotNull File saveLocation) {
        this(saveLocation, null, 2, null);
    }

    static {
        Companion = new Companion(null);
        ADAPTER_TYPE = Types.newParameterizedType((Type)((Type)((Object)Map.class)), (Type[])new Type[]{(Type)((Object)String.class), (Type)((Object)PersistedAuthData.class)});
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/dean/jraw/oauth/JsonFileTokenStore$Companion;", "", "()V", "ADAPTER_TYPE", "Ljava/lang/reflect/ParameterizedType;", "kotlin.jvm.PlatformType", "lib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

