/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.oauth;

import com.squareup.moshi.JsonAdapter;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.dean.jraw.JrawUtils;
import net.dean.jraw.RedditClient;
import net.dean.jraw.http.HttpRequest;
import net.dean.jraw.http.HttpResponse;
import net.dean.jraw.http.NetworkAdapter;
import net.dean.jraw.http.NetworkException;
import net.dean.jraw.models.OAuthData;
import net.dean.jraw.models.internal.OAuthDataJson;
import net.dean.jraw.oauth.AuthMethod;
import net.dean.jraw.oauth.Credentials;
import net.dean.jraw.oauth.NoopTokenStore;
import net.dean.jraw.oauth.OAuthHelper;
import net.dean.jraw.oauth.StatefulAuthHelper;
import net.dean.jraw.oauth.TokenStore;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b\tJ\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007JL\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\r2#\b\u0002\u0010\u0010\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00150\u0011H\u0001\u00a2\u0006\u0002\b\u0016J\u001d\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b\u0018\u00a8\u0006\u0019"}, d2={"Lnet/dean/jraw/oauth/OAuthHelper;", "", "()V", "applicationOnlyOAuthData", "Lnet/dean/jraw/models/OAuthData;", "http", "Lnet/dean/jraw/http/NetworkAdapter;", "creds", "Lnet/dean/jraw/oauth/Credentials;", "applicationOnlyOAuthData$lib", "automatic", "Lnet/dean/jraw/RedditClient;", "tokenStore", "Lnet/dean/jraw/oauth/TokenStore;", "interactive", "Lnet/dean/jraw/oauth/StatefulAuthHelper;", "onAuthenticated", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "r", "", "interactive$lib", "scriptOAuthData", "scriptOAuthData$lib", "lib"})
public final class OAuthHelper {
    public static final OAuthHelper INSTANCE;

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final RedditClient automatic(@NotNull NetworkAdapter http, @NotNull Credentials creds, @NotNull TokenStore tokenStore) {
        RedditClient redditClient;
        Intrinsics.checkParameterIsNotNull((Object)http, (String)"http");
        Intrinsics.checkParameterIsNotNull((Object)creds, (String)"creds");
        Intrinsics.checkParameterIsNotNull((Object)tokenStore, (String)"tokenStore");
        if (creds.getAuthMethod().isUserless()) {
            redditClient = new RedditClient(http, OAuthHelper.applicationOnlyOAuthData$lib(http, creds), creds, tokenStore, "<userless>");
        } else if (creds.getAuthMethod() == AuthMethod.SCRIPT) {
            redditClient = new RedditClient(http, OAuthHelper.scriptOAuthData$lib(http, creds), creds, tokenStore, creds.getUsername());
        } else {
            throw (Throwable)new IllegalArgumentException("AuthMethod " + (Object)((Object)creds.getAuthMethod()) + " is not eligible for automatic authentication");
        }
        return redditClient;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ RedditClient automatic$default(NetworkAdapter networkAdapter, Credentials credentials, TokenStore tokenStore, int n, Object object) {
        if ((n & 4) != 0) {
            tokenStore = new NoopTokenStore();
        }
        return OAuthHelper.automatic(networkAdapter, credentials, tokenStore);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final RedditClient automatic(@NotNull NetworkAdapter http, @NotNull Credentials creds) {
        return OAuthHelper.automatic$default(http, creds, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final StatefulAuthHelper interactive(@NotNull NetworkAdapter http, @NotNull Credentials creds, @NotNull TokenStore tokenStore) {
        Intrinsics.checkParameterIsNotNull((Object)http, (String)"http");
        Intrinsics.checkParameterIsNotNull((Object)creds, (String)"creds");
        Intrinsics.checkParameterIsNotNull((Object)tokenStore, (String)"tokenStore");
        return OAuthHelper.interactive$lib(http, creds, tokenStore, (Function1<? super RedditClient, Unit>)((Function1)interactive.1.INSTANCE));
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ StatefulAuthHelper interactive$default(NetworkAdapter networkAdapter, Credentials credentials, TokenStore tokenStore, int n, Object object) {
        if ((n & 4) != 0) {
            tokenStore = new NoopTokenStore();
        }
        return OAuthHelper.interactive(networkAdapter, credentials, tokenStore);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final StatefulAuthHelper interactive(@NotNull NetworkAdapter http, @NotNull Credentials creds) {
        return OAuthHelper.interactive$default(http, creds, null, 4, null);
    }

    @JvmStatic
    @NotNull
    public static final StatefulAuthHelper interactive$lib(@NotNull NetworkAdapter http, @NotNull Credentials creds, @NotNull TokenStore tokenStore, @NotNull Function1<? super RedditClient, Unit> onAuthenticated) {
        Intrinsics.checkParameterIsNotNull((Object)http, (String)"http");
        Intrinsics.checkParameterIsNotNull((Object)creds, (String)"creds");
        Intrinsics.checkParameterIsNotNull((Object)tokenStore, (String)"tokenStore");
        Intrinsics.checkParameterIsNotNull(onAuthenticated, (String)"onAuthenticated");
        if (creds.getAuthMethod() != AuthMethod.APP && creds.getAuthMethod() != AuthMethod.WEBAPP) {
            throw (Throwable)new IllegalArgumentException("AuthMethod " + (Object)((Object)creds.getAuthMethod()) + " should use automatic authentication");
        }
        return new StatefulAuthHelper(http, creds, tokenStore, onAuthenticated);
    }

    @JvmStatic
    @NotNull
    public static /* bridge */ /* synthetic */ StatefulAuthHelper interactive$lib$default(NetworkAdapter networkAdapter, Credentials credentials, TokenStore tokenStore, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            tokenStore = new NoopTokenStore();
        }
        if ((n & 8) != 0) {
            function1 = interactive.2.INSTANCE;
        }
        return OAuthHelper.interactive$lib(networkAdapter, credentials, tokenStore, (Function1<? super RedditClient, Unit>)function1);
    }

    @JvmStatic
    @NotNull
    public static final OAuthData scriptOAuthData$lib(@NotNull NetworkAdapter http, @NotNull Credentials creds) {
        Intrinsics.checkParameterIsNotNull((Object)http, (String)"http");
        Intrinsics.checkParameterIsNotNull((Object)creds, (String)"creds");
        if (creds.getAuthMethod() != AuthMethod.SCRIPT) {
            throw (Throwable)new IllegalArgumentException("This function is for script apps only");
        }
        try {
            HttpRequest.Builder builder = new HttpRequest.Builder();
            Pair[] pairArray = new Pair[3];
            pairArray[0] = TuplesKt.to((Object)"grant_type", (Object)"password");
            String string = creds.getUsername();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            pairArray[1] = TuplesKt.to((Object)"username", (Object)string);
            String string2 = creds.getPassword();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            pairArray[2] = TuplesKt.to((Object)"password", (Object)string2);
            HttpResponse this_$iv = http.execute(builder.post(MapsKt.mapOf((Pair[])pairArray)).url("https://www.reddit.com/api/v1/access_token").basicAuth((Pair<String, String>)TuplesKt.to((Object)creds.getClientId(), (Object)creds.getClientSecret())).build());
            HttpResponse httpResponse = this_$iv;
            JsonAdapter jsonAdapter = JrawUtils.moshi.adapter(OAuthDataJson.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"moshi.adapter(T::class.java)");
            JsonAdapter jsonAdapter2 = jsonAdapter;
            OAuthData oAuthData = ((OAuthDataJson)httpResponse.deserializeWith(jsonAdapter2)).toOAuthData();
            Intrinsics.checkExpressionValueIsNotNull((Object)oAuthData, (String)"http.execute(HttpRequest\u2026DataJson>().toOAuthData()");
            return oAuthData;
        }
        catch (NetworkException e) {
            if (e.getRes().getCode() == 401) {
                throw (Throwable)new IllegalArgumentException("Invalid credentials", e);
            }
            throw (Throwable)e;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final OAuthData applicationOnlyOAuthData$lib(@NotNull NetworkAdapter http, @NotNull Credentials creds) {
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)http, (String)"http");
        Intrinsics.checkParameterIsNotNull((Object)creds, (String)"creds");
        if (!creds.getAuthMethod().isUserless()) {
            throw (Throwable)new IllegalArgumentException("" + (Object)((Object)creds.getAuthMethod()) + " is not a userless authentication method");
        }
        String grantType = creds.getAuthMethod() == AuthMethod.USERLESS_APP ? "https://oauth.reddit.com/grants/installed_client" : "client_credentials";
        Map postBody = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"grant_type", (Object)grantType)});
        if (creds.getAuthMethod() == AuthMethod.USERLESS_APP) {
            postBody.put("device_id", String.valueOf(creds.getDeviceId()));
        }
        HttpResponse httpResponse = http.execute(new HttpRequest.Builder().url("https://www.reddit.com/api/v1/access_token").post(postBody).basicAuth((Pair<String, String>)TuplesKt.to((Object)creds.getClientId(), (Object)creds.getClientSecret())).build());
        void var5_5 = this_$iv;
        JsonAdapter jsonAdapter = JrawUtils.moshi.adapter(OAuthDataJson.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"moshi.adapter(T::class.java)");
        JsonAdapter jsonAdapter2 = jsonAdapter;
        OAuthData oAuthData = ((OAuthDataJson)var5_5.deserializeWith(jsonAdapter2)).toOAuthData();
        Intrinsics.checkExpressionValueIsNotNull((Object)oAuthData, (String)"http.execute(HttpRequest\u2026DataJson>().toOAuthData()");
        return oAuthData;
    }

    private OAuthHelper() {
    }

    static {
        OAuthHelper oAuthHelper;
        INSTANCE = oAuthHelper = new OAuthHelper();
    }
}

