/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.oauth;

import com.squareup.moshi.JsonAdapter;
import java.math.BigInteger;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.dean.jraw.JrawUtils;
import net.dean.jraw.RedditClient;
import net.dean.jraw.http.HttpRequest;
import net.dean.jraw.http.NetworkAdapter;
import net.dean.jraw.http.NetworkException;
import net.dean.jraw.models.OAuthData;
import net.dean.jraw.models.internal.OAuthDataJson;
import net.dean.jraw.oauth.Credentials;
import net.dean.jraw.oauth.OAuthException;
import net.dean.jraw.oauth.TokenStore;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\b\u0018\u0000 \"2\u00020\u0001:\u0002\"#BB\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012!\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\t\u00a2\u0006\u0002\u0010\u000fJ3\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u00192\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u001c\"\u00020\u0016\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0016J\u0010\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\u0016H\u0007R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lnet/dean/jraw/oauth/StatefulAuthHelper;", "", "http", "Lnet/dean/jraw/http/NetworkAdapter;", "creds", "Lnet/dean/jraw/oauth/Credentials;", "tokenStore", "Lnet/dean/jraw/oauth/TokenStore;", "onAuthenticated", "Lkotlin/Function1;", "Lnet/dean/jraw/RedditClient;", "Lkotlin/ParameterName;", "name", "reddit", "", "(Lnet/dean/jraw/http/NetworkAdapter;Lnet/dean/jraw/oauth/Credentials;Lnet/dean/jraw/oauth/TokenStore;Lkotlin/jvm/functions/Function1;)V", "_authStatus", "Lnet/dean/jraw/oauth/StatefulAuthHelper$Status;", "authStatus", "getAuthStatus", "()Lnet/dean/jraw/oauth/StatefulAuthHelper$Status;", "state", "", "getAuthorizationUrl", "requestRefreshToken", "", "useMobileSite", "scopes", "", "(ZZ[Ljava/lang/String;)Ljava/lang/String;", "isFinalRedirectUrl", "url", "onUserChallenge", "finalUrl", "Companion", "Status", "lib"})
public final class StatefulAuthHelper {
    private String state;
    private Status _authStatus;
    private final NetworkAdapter http;
    private final Credentials creds;
    private final TokenStore tokenStore;
    private final Function1<RedditClient, Unit> onAuthenticated;
    private static final SecureRandom rand;
    public static final Companion Companion;

    @NotNull
    public final Status getAuthStatus() {
        return this._authStatus;
    }

    @NotNull
    public final String getAuthorizationUrl(boolean requestRefreshToken, boolean useMobileSite, String ... scopes) {
        Intrinsics.checkParameterIsNotNull((Object)scopes, (String)"scopes");
        this.state = new BigInteger(128, rand).toString(32);
        this._authStatus = Status.WAITING_FOR_CHALLENGE;
        HttpRequest.Builder builder = new HttpRequest.Builder().secure(true).host("www.reddit.com").path("/api/v1/authorize" + (useMobileSite ? ".compact" : ""), new String[0]);
        Pair[] pairArray = new Pair[6];
        pairArray[0] = TuplesKt.to((Object)"client_id", (Object)this.creds.getClientId());
        pairArray[1] = TuplesKt.to((Object)"response_type", (Object)"code");
        String string = this.state;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        pairArray[2] = TuplesKt.to((Object)"state", (Object)string);
        String string2 = this.creds.getRedirectUrl();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[3] = TuplesKt.to((Object)"redirect_uri", (Object)string2);
        pairArray[4] = TuplesKt.to((Object)"duration", (Object)(requestRefreshToken ? "permanent" : "temporary"));
        pairArray[5] = TuplesKt.to((Object)"scope", (Object)ArraysKt.joinToString$default((Object[])scopes, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        return builder.query(MapsKt.mapOf((Pair[])pairArray)).build().getUrl();
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String getAuthorizationUrl$default(StatefulAuthHelper statefulAuthHelper, boolean bl, boolean bl2, String[] stringArray, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return statefulAuthHelper.getAuthorizationUrl(bl, bl2, stringArray);
    }

    public final boolean isFinalRedirectUrl(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        HttpUrl httpUrl = HttpUrl.parse((String)url);
        if (httpUrl == null) {
            throw (Throwable)new IllegalArgumentException("Malformed URL: " + url);
        }
        HttpUrl httpUrl2 = httpUrl;
        if (this.creds.getRedirectUrl() == null) {
            throw (Throwable)new IllegalStateException("Given credentials have no redirect URL");
        }
        return StringsKt.startsWith$default((String)httpUrl2.toString(), (String)this.creds.getRedirectUrl(), (boolean)false, (int)2, null) && httpUrl2.queryParameter("state") != null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RedditClient onUserChallenge(@NotNull String finalUrl) throws NetworkException, OAuthException, IllegalStateException {
        Map<String, String> query;
        Intrinsics.checkParameterIsNotNull((Object)finalUrl, (String)"finalUrl");
        if (this.getAuthStatus() != Status.WAITING_FOR_CHALLENGE) {
            throw (Throwable)new IllegalStateException("Expecting auth status " + (Object)((Object)Status.WAITING_FOR_CHALLENGE) + ", got " + (Object)((Object)this.getAuthStatus()));
        }
        String string = new URL(finalUrl).getQuery();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"URL(finalUrl).query");
        Map<String, String> map = query = JrawUtils.parseUrlEncoded(string);
        String string2 = "error";
        Map<String, String> map2 = map;
        if (map2.containsKey(string2)) {
            throw (Throwable)new OAuthException("Reddit responded with error: " + query.get("error"), null, 2, null);
        }
        map = query;
        map2 = map;
        string2 = "state";
        if (!map2.containsKey(string2)) {
            throw (Throwable)new IllegalArgumentException("Final redirect URL did not contain the 'state' query parameter");
        }
        if (Intrinsics.areEqual((Object)query.get("state"), (Object)this.state) ^ true) {
            throw (Throwable)new IllegalStateException("State did not match");
        }
        map = query;
        map2 = map;
        string2 = "code";
        if (!map2.containsKey(string2)) {
            throw (Throwable)new IllegalArgumentException("Final redirect URL did not contain the 'code' query parameter");
        }
        String string3 = query.get("code");
        if (string3 == null) {
            Intrinsics.throwNpe();
        }
        String code = string3;
        try {
            void this_$iv;
            HttpRequest.Builder builder = new HttpRequest.Builder().secure(true).host("www.reddit.com").path("/api/v1/access_token", new String[0]);
            Pair[] pairArray = new Pair[3];
            pairArray[0] = TuplesKt.to((Object)"grant_type", (Object)"authorization_code");
            pairArray[1] = TuplesKt.to((Object)"code", (Object)code);
            String string4 = this.creds.getRedirectUrl();
            if (string4 == null) {
                Intrinsics.throwNpe();
            }
            pairArray[2] = TuplesKt.to((Object)"redirect_uri", (Object)string4);
            map2 = this.http.execute(builder.post(MapsKt.mapOf((Pair[])pairArray)).basicAuth((Pair<String, String>)TuplesKt.to((Object)this.creds.getClientId(), (Object)this.creds.getClientSecret())).build());
            void var6_7 = this_$iv;
            JsonAdapter jsonAdapter = JrawUtils.moshi.adapter(OAuthDataJson.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"moshi.adapter(T::class.java)");
            JsonAdapter jsonAdapter2 = jsonAdapter;
            OAuthData oAuthData = ((OAuthDataJson)var6_7.deserializeWith(jsonAdapter2)).toOAuthData();
            Intrinsics.checkExpressionValueIsNotNull((Object)oAuthData, (String)"http.execute(HttpRequest\u2026DataJson>().toOAuthData()");
            OAuthData response = oAuthData;
            this._authStatus = Status.AUTHORIZED;
            RedditClient r = new RedditClient(this.http, response, this.creds, this.tokenStore, null, 16, null);
            this.onAuthenticated.invoke((Object)r);
            return r;
        }
        catch (NetworkException ex) {
            if (ex.getRes().getCode() == 401) {
                throw (Throwable)new OAuthException("Invalid client ID/secret", ex);
            }
            throw (Throwable)ex;
        }
    }

    public StatefulAuthHelper(@NotNull NetworkAdapter http, @NotNull Credentials creds, @NotNull TokenStore tokenStore, @NotNull Function1<? super RedditClient, Unit> onAuthenticated) {
        Intrinsics.checkParameterIsNotNull((Object)http, (String)"http");
        Intrinsics.checkParameterIsNotNull((Object)creds, (String)"creds");
        Intrinsics.checkParameterIsNotNull((Object)tokenStore, (String)"tokenStore");
        Intrinsics.checkParameterIsNotNull(onAuthenticated, (String)"onAuthenticated");
        this.http = http;
        this.creds = creds;
        this.tokenStore = tokenStore;
        this.onAuthenticated = onAuthenticated;
        this._authStatus = Status.INIT;
    }

    static {
        Companion = new Companion(null);
        rand = new SecureRandom();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lnet/dean/jraw/oauth/StatefulAuthHelper$Status;", "", "(Ljava/lang/String;I)V", "INIT", "WAITING_FOR_CHALLENGE", "AUTHORIZED", "lib"})
    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status INIT;
        public static final /* enum */ Status WAITING_FOR_CHALLENGE;
        public static final /* enum */ Status AUTHORIZED;
        private static final /* synthetic */ Status[] $VALUES;

        static {
            Status[] statusArray = new Status[3];
            Status[] statusArray2 = statusArray;
            statusArray[0] = INIT = new Status();
            statusArray[1] = WAITING_FOR_CHALLENGE = new Status();
            statusArray[2] = AUTHORIZED = new Status();
            $VALUES = statusArray;
        }

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String string) {
            return Enum.valueOf(Status.class, string);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/dean/jraw/oauth/StatefulAuthHelper$Companion;", "", "()V", "rand", "Ljava/security/SecureRandom;", "lib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

