/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.pagination;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.dean.jraw.JrawUtils;
import net.dean.jraw.RedditClient;
import net.dean.jraw.databind.Enveloped;
import net.dean.jraw.http.HttpRequest;
import net.dean.jraw.models.GeneralSort;
import net.dean.jraw.models.Listing;
import net.dean.jraw.models.Sorting;
import net.dean.jraw.models.TimePeriod;
import net.dean.jraw.models.UniquelyIdentifiable;
import net.dean.jraw.pagination.BackoffStrategy;
import net.dean.jraw.pagination.RedditIterable;
import net.dean.jraw.pagination.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000 +*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0002*+B-\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0002\u0010\fJ\u001c\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\u001e2\u0006\u0010\u001f\u001a\u00020\tH\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u001e2\u0006\u0010\u001f\u001a\u00020\tH\u0016J\b\u0010!\u001a\u00020\"H$J\b\u0010#\u001a\u00020$H\u0016J\u0015\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0&H\u0096\u0002J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eH\u0016J\b\u0010(\u001a\u00020)H\u0016R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006,"}, d2={"Lnet/dean/jraw/pagination/Paginator;", "T", "Lnet/dean/jraw/models/UniquelyIdentifiable;", "Lnet/dean/jraw/pagination/RedditIterable;", "reddit", "Lnet/dean/jraw/RedditClient;", "baseUrl", "", "limit", "", "clazz", "Ljava/lang/Class;", "(Lnet/dean/jraw/RedditClient;Ljava/lang/String;ILjava/lang/Class;)V", "_current", "Lnet/dean/jraw/models/Listing;", "_pageNumber", "adapter", "Lcom/squareup/moshi/JsonAdapter;", "getBaseUrl", "()Ljava/lang/String;", "current", "getCurrent", "()Lnet/dean/jraw/models/Listing;", "getLimit", "()I", "pageNumber", "getPageNumber", "getReddit", "()Lnet/dean/jraw/RedditClient;", "accumulate", "", "maxPages", "accumulateMerged", "createNextRequest", "Lnet/dean/jraw/http/HttpRequest$Builder;", "hasStarted", "", "iterator", "", "next", "restart", "", "Builder", "Companion", "lib"})
public abstract class Paginator<T extends UniquelyIdentifiable>
implements RedditIterable<T> {
    private Listing<T> _current;
    private int _pageNumber;
    private final JsonAdapter<Listing<T>> adapter;
    @NotNull
    private final String baseUrl;
    @NotNull
    private final RedditClient reddit;
    private final int limit;
    public static final int RECOMMENDED_MAX_LIMIT = 100;
    public static final int DEFAULT_LIMIT = 25;
    @JvmField
    @NotNull
    public static final Sorting DEFAULT_SORTING;
    @JvmField
    @NotNull
    public static final TimePeriod DEFAULT_TIME_PERIOD;
    public static final Companion Companion;

    @NotNull
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    @Nullable
    public Listing<T> getCurrent() {
        return this._current;
    }

    @Override
    public int getPageNumber() {
        return this._pageNumber;
    }

    @Override
    @NotNull
    public Listing<T> next() {
        this._current = this.reddit.request(this.createNextRequest().build()).deserializeWith(this.adapter);
        int n = this._pageNumber;
        this._pageNumber = n + 1;
        Listing<T> listing = this._current;
        if (listing == null) {
            Intrinsics.throwNpe();
        }
        return listing;
    }

    @Override
    public void restart() {
        this._current = null;
        this._pageNumber = 0;
    }

    @Override
    @NotNull
    public Iterator<Listing<T>> iterator() {
        return new Iterator<Listing<T>>(this){
            final /* synthetic */ Paginator this$0;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean hasNext() {
                if (!this.this$0.hasStarted()) return true;
                if (Paginator.access$get_current$p(this.this$0) == null) return false;
                Listing listing = Paginator.access$get_current$p(this.this$0);
                if (listing == null) {
                    Intrinsics.throwNpe();
                }
                if (listing.getNextName() == null) return false;
                return true;
            }

            @NotNull
            public Listing<T> next() {
                return this.this$0.next();
            }
            {
                this.this$0 = $outer;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @Override
    public boolean hasStarted() {
        return this._current != null && this._pageNumber > 0;
    }

    @Override
    @NotNull
    public List<Listing<T>> accumulate(int maxPages) {
        List lists = new ArrayList();
        if (maxPages < -1) {
            throw (Throwable)new IllegalArgumentException("Expecting maxPages to be -1 or greater");
        }
        int i = 0;
        Iterator<Listing<T>> it = this.iterator();
        while ((maxPages == -1 || ++i <= maxPages) && it.hasNext()) {
            lists.add(it.next());
        }
        return lists;
    }

    @Override
    @NotNull
    public List<T> accumulateMerged(int maxPages) {
        return CollectionsKt.flatten((Iterable)this.accumulate(maxPages));
    }

    @NotNull
    protected abstract HttpRequest.Builder createNextRequest();

    @NotNull
    public final RedditClient getReddit() {
        return this.reddit;
    }

    public final int getLimit() {
        return this.limit;
    }

    protected Paginator(@NotNull RedditClient reddit, @NotNull String baseUrl, int limit, @NotNull Class<T> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)reddit, (String)"reddit");
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        this.reddit = reddit;
        this.limit = limit;
        ParameterizedType type = Types.newParameterizedType((Type)((Type)((Object)Listing.class)), (Type[])new Type[]{clazz});
        JsonAdapter jsonAdapter = JrawUtils.moshi.adapter((Type)type, Enveloped.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"JrawUtils.moshi.adapter(\u2026e, Enveloped::class.java)");
        this.adapter = jsonAdapter;
        this.baseUrl = StringsKt.removeSuffix((String)baseUrl, (CharSequence)"/");
    }

    static {
        Companion = new Companion(null);
        DEFAULT_SORTING = GeneralSort.HOT;
        DEFAULT_TIME_PERIOD = TimePeriod.DAY;
    }

    @Override
    @NotNull
    public Stream<T> stream() {
        return RedditIterable.DefaultImpls.stream(this);
    }

    @Override
    @NotNull
    public Stream<T> stream(@NotNull BackoffStrategy backoff) {
        Intrinsics.checkParameterIsNotNull((Object)backoff, (String)"backoff");
        return RedditIterable.DefaultImpls.stream(this, backoff);
    }

    @Nullable
    public static final /* synthetic */ Listing access$get_current$p(Paginator $this) {
        return $this._current;
    }

    public static final /* synthetic */ void access$set_current$p(Paginator $this, @Nullable Listing listing) {
        $this._current = listing;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u0012H&R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lnet/dean/jraw/pagination/Paginator$Builder;", "T", "Lnet/dean/jraw/models/UniquelyIdentifiable;", "", "reddit", "Lnet/dean/jraw/RedditClient;", "baseUrl", "", "clazz", "Ljava/lang/Class;", "(Lnet/dean/jraw/RedditClient;Ljava/lang/String;Ljava/lang/Class;)V", "getBaseUrl", "()Ljava/lang/String;", "getClazz", "()Ljava/lang/Class;", "getReddit", "()Lnet/dean/jraw/RedditClient;", "build", "Lnet/dean/jraw/pagination/Paginator;", "lib"})
    public static abstract class Builder<T extends UniquelyIdentifiable> {
        @NotNull
        private final RedditClient reddit;
        @NotNull
        private final String baseUrl;
        @NotNull
        private final Class<T> clazz;

        @NotNull
        public abstract Paginator<T> build();

        @NotNull
        public final RedditClient getReddit() {
            return this.reddit;
        }

        @NotNull
        public final String getBaseUrl() {
            return this.baseUrl;
        }

        @NotNull
        protected final Class<T> getClazz() {
            return this.clazz;
        }

        public Builder(@NotNull RedditClient reddit, @NotNull String baseUrl, @NotNull Class<T> clazz) {
            Intrinsics.checkParameterIsNotNull((Object)reddit, (String)"reddit");
            Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
            Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
            this.reddit = reddit;
            this.baseUrl = baseUrl;
            this.clazz = clazz;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lnet/dean/jraw/pagination/Paginator$Companion;", "", "()V", "DEFAULT_LIMIT", "", "DEFAULT_SORTING", "Lnet/dean/jraw/models/Sorting;", "DEFAULT_TIME_PERIOD", "Lnet/dean/jraw/models/TimePeriod;", "RECOMMENDED_MAX_LIMIT", "lib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

