/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.pagination;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import net.dean.jraw.models.UniquelyIdentifiable;
import net.dean.jraw.pagination.BackoffStrategy;
import net.dean.jraw.pagination.ConstantBackoffStrategy;
import net.dean.jraw.pagination.RedditIterable;
import net.dean.jraw.pagination.RotatingSearchList;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B)\b\u0007\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0011\u001a\u00020\u0012H\u0096\u0002J\u000e\u0010\u0013\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0003X\u0088\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0088\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnet/dean/jraw/pagination/Stream;", "T", "Lnet/dean/jraw/models/UniquelyIdentifiable;", "", "dataSource", "Lnet/dean/jraw/pagination/RedditIterable;", "backoff", "Lnet/dean/jraw/pagination/BackoffStrategy;", "historySize", "", "(Lnet/dean/jraw/pagination/RedditIterable;Lnet/dean/jraw/pagination/BackoffStrategy;I)V", "currentIterator", "history", "Lnet/dean/jraw/pagination/RotatingSearchList;", "", "resumeTimeMillis", "", "hasNext", "", "next", "()Lnet/dean/jraw/models/UniquelyIdentifiable;", "requestNew", "lib"})
public final class Stream<T extends UniquelyIdentifiable>
implements Iterator<T>,
KMappedMarker {
    private final RotatingSearchList<String> history;
    private Iterator<? extends T> currentIterator;
    private long resumeTimeMillis;
    private final RedditIterable<T> dataSource;
    private final BackoffStrategy backoff;

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    @NotNull
    public T next() {
        Iterator<T> it = this.currentIterator;
        if (it != null && it.hasNext()) {
            return (T)((UniquelyIdentifiable)it.next());
        }
        Iterator<T> iterator2 = this.requestNew();
        this.currentIterator = iterator2;
        return (T)((UniquelyIdentifiable)iterator2.next());
    }

    /*
     * WARNING - void declaration
     */
    private final Iterator<T> requestNew() {
        Iterator newDataIterator = null;
        while (newDataIterator == null) {
            boolean bl;
            void new_;
            if (this.resumeTimeMillis > System.currentTimeMillis()) {
                Thread.sleep(this.resumeTimeMillis - System.currentTimeMillis());
            }
            this.dataSource.restart();
            Iterable $receiver$iv = this.dataSource.next();
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $receiver$iv) {
                UniquelyIdentifiable it = (UniquelyIdentifiable)element$iv;
                if (this.history.contains(it.getUniqueId())) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List list = (List)pair.component1();
            List old = (List)pair.component2();
            Iterable $receiver$iv2 = old;
            for (Object element$iv : $receiver$iv2) {
                UniquelyIdentifiable it = (UniquelyIdentifiable)element$iv;
                this.history.add(it.getUniqueId());
            }
            long backoffMillis = this.backoff.delayRequest(old.size(), new_.size() + old.size());
            boolean bl2 = bl = backoffMillis >= 0L;
            if (!bl) {
                String string = "delayRequest must return a non-negative integer, was " + backoffMillis;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            this.resumeTimeMillis = System.currentTimeMillis() + this.backoff.delayRequest(old.size(), new_.size() + old.size());
            Collection collection = old;
            if (!(!collection.isEmpty())) continue;
            newDataIterator = CollectionsKt.asReversed((List)old).iterator();
        }
        return newDataIterator;
    }

    @JvmOverloads
    public Stream(@NotNull RedditIterable<T> dataSource, @NotNull BackoffStrategy backoff, int historySize) {
        Intrinsics.checkParameterIsNotNull(dataSource, (String)"dataSource");
        Intrinsics.checkParameterIsNotNull((Object)backoff, (String)"backoff");
        this.dataSource = dataSource;
        this.backoff = backoff;
        this.history = new RotatingSearchList(historySize);
        this.resumeTimeMillis = -1L;
    }

    @JvmOverloads
    public /* synthetic */ Stream(RedditIterable redditIterable, BackoffStrategy backoffStrategy, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            backoffStrategy = new ConstantBackoffStrategy(0L, 1, null);
        }
        if ((n2 & 4) != 0) {
            n = 500;
        }
        this(redditIterable, backoffStrategy, n);
    }

    @JvmOverloads
    public Stream(@NotNull RedditIterable<T> dataSource, @NotNull BackoffStrategy backoff) {
        this(dataSource, backoff, 0, 4, null);
    }

    @JvmOverloads
    public Stream(@NotNull RedditIterable<T> dataSource) {
        this(dataSource, null, 0, 6, null);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

