/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.ratelimit;

import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.dean.jraw.ratelimit.RefillStrategy;
import net.dean.jraw.ratelimit.SystemTimeAdapter;
import net.dean.jraw.ratelimit.TimeAdapter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0011\u001a\u00020\u0003H\u0016J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnet/dean/jraw/ratelimit/FixedIntervalRefillStrategy;", "Lnet/dean/jraw/ratelimit/RefillStrategy;", "permitsPerPeriod", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(JLjava/util/concurrent/TimeUnit;)V", "timeAdapter", "Lnet/dean/jraw/ratelimit/TimeAdapter;", "(JLjava/util/concurrent/TimeUnit;Lnet/dean/jraw/ratelimit/TimeAdapter;)V", "durationNanos", "lastRefillTime", "lock", "", "nextRefillTime", "getPermitsPerPeriod", "()J", "refill", "timeUntilNextRefill", "lib"})
public final class FixedIntervalRefillStrategy
implements RefillStrategy {
    private final long durationNanos;
    private long lastRefillTime;
    private long nextRefillTime;
    private final Object lock;
    private final long permitsPerPeriod;
    private final TimeAdapter timeAdapter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long refill() {
        Object object = this.lock;
        synchronized (object) {
            long now;
            block4: {
                now = this.timeAdapter.nanoTime();
                if (now >= this.nextRefillTime) break block4;
                long l = 0L;
                return l;
            }
            long numPeriods = Math.max(0L, (now - this.lastRefillTime) / this.durationNanos);
            this.lastRefillTime += numPeriods * this.durationNanos;
            this.nextRefillTime = this.lastRefillTime + this.durationNanos;
            long l = numPeriods * this.permitsPerPeriod;
            return l;
        }
    }

    @Override
    public long timeUntilNextRefill(@NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        long now = this.timeAdapter.nanoTime();
        return unit.convert(Math.max(0L, this.nextRefillTime - now), TimeUnit.NANOSECONDS);
    }

    public final long getPermitsPerPeriod() {
        return this.permitsPerPeriod;
    }

    public FixedIntervalRefillStrategy(long permitsPerPeriod, @NotNull TimeUnit unit, @NotNull TimeAdapter timeAdapter) {
        long now;
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        Intrinsics.checkParameterIsNotNull((Object)timeAdapter, (String)"timeAdapter");
        this.permitsPerPeriod = permitsPerPeriod;
        this.timeAdapter = timeAdapter;
        this.durationNanos = unit.toNanos(this.permitsPerPeriod);
        this.lock = new Object();
        this.lastRefillTime = now = this.timeAdapter.nanoTime();
        this.nextRefillTime = now + this.durationNanos;
    }

    public FixedIntervalRefillStrategy(long permitsPerPeriod, @NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        this(permitsPerPeriod, unit, new SystemTimeAdapter());
    }
}

