/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.ratelimit;

import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.dean.jraw.ratelimit.AbstractRateLimiter;
import net.dean.jraw.ratelimit.FixedIntervalRefillStrategy;
import net.dean.jraw.ratelimit.RefillStrategy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnet/dean/jraw/ratelimit/LeakyBucketRateLimiter;", "Lnet/dean/jraw/ratelimit/AbstractRateLimiter;", "capacity", "", "permitsPerPeriod", "unit", "Ljava/util/concurrent/TimeUnit;", "(JJLjava/util/concurrent/TimeUnit;)V", "refillStrategy", "Lnet/dean/jraw/ratelimit/RefillStrategy;", "(JLnet/dean/jraw/ratelimit/RefillStrategy;)V", "getCapacity", "()J", "initialPermits", "getRefillStrategy", "()Lnet/dean/jraw/ratelimit/RefillStrategy;", "size", "refill", "", "permits", "tryAcquire", "", "lib"})
public final class LeakyBucketRateLimiter
extends AbstractRateLimiter {
    private final long initialPermits = 0L;
    private long size;
    private final long capacity;
    @NotNull
    private final RefillStrategy refillStrategy;

    @Override
    public boolean tryAcquire(long permits) {
        if (permits <= 0L) {
            throw (Throwable)new IllegalArgumentException("permits must be above 0");
        }
        if (permits > this.capacity) {
            throw (Throwable)new IllegalArgumentException("permits must be below capacity (" + this.capacity + ')');
        }
        this.refill(this.refillStrategy.refill());
        if (permits <= this.size) {
            this.size -= permits;
            return true;
        }
        return false;
    }

    @Override
    public void refill(long permits) {
        long newPermits = Math.min(this.capacity, Math.max(0L, permits));
        this.size = Math.max(0L, Math.min(this.size + newPermits, this.capacity));
    }

    public final long getCapacity() {
        return this.capacity;
    }

    @NotNull
    public final RefillStrategy getRefillStrategy() {
        return this.refillStrategy;
    }

    public LeakyBucketRateLimiter(long capacity, @NotNull RefillStrategy refillStrategy) {
        Intrinsics.checkParameterIsNotNull((Object)refillStrategy, (String)"refillStrategy");
        this.capacity = capacity;
        this.refillStrategy = refillStrategy;
        this.size = this.initialPermits;
        if (this.capacity <= 0L) {
            throw (Throwable)new IllegalArgumentException("expecting a permit capacity > 0");
        }
        if (this.initialPermits > this.capacity) {
            throw (Throwable)new IllegalArgumentException("initialPermits cannot be higher than capacity");
        }
    }

    public LeakyBucketRateLimiter(long capacity, long permitsPerPeriod, @NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        this(capacity, new FixedIntervalRefillStrategy(permitsPerPeriod, unit));
    }
}

