/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.references;

import com.squareup.moshi.JsonAdapter;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.dean.jraw.ApiException;
import net.dean.jraw.Endpoint;
import net.dean.jraw.EndpointImplementation;
import net.dean.jraw.JrawUtils;
import net.dean.jraw.RedditClient;
import net.dean.jraw.databind.Enveloped;
import net.dean.jraw.http.HttpRequest;
import net.dean.jraw.models.Comment;
import net.dean.jraw.models.DistinguishedStatus;
import net.dean.jraw.models.VoteDirection;
import net.dean.jraw.references.PublicContributionReference$WhenMappings;
import net.dean.jraw.references.ReplyableReference;
import net.dean.jraw.references.SubmissionReference;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000e\u001a\u00020\rH\u0007J\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0006\u0010\u0014\u001a\u00020\rJ\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0005H\u0007J\u0012\u0010\u0017\u001a\u00020\r2\b\b\u0002\u0010\u0018\u001a\u00020\u0013H\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0005H\u0007J\u0006\u0010\u001b\u001a\u00020\rJ\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0013H\u0007J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u0013H\u0007J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!H\u0007J\u0006\u0010\"\u001a\u00020\rJ\u0006\u0010#\u001a\u00020\rJ\u0006\u0010$\u001a\u00020\rR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006%"}, d2={"Lnet/dean/jraw/references/PublicContributionReference;", "Lnet/dean/jraw/references/ReplyableReference;", "reddit", "Lnet/dean/jraw/RedditClient;", "id", "", "kindPrefix", "(Lnet/dean/jraw/RedditClient;Ljava/lang/String;Ljava/lang/String;)V", "fullName", "getFullName", "()Ljava/lang/String;", "getId", "approve", "", "delete", "distinguish", "how", "Lnet/dean/jraw/models/DistinguishedStatus;", "sticky", "", "downvote", "edit", "text", "remove", "spam", "reply", "Lnet/dean/jraw/models/Comment;", "save", "sendReplies", "setSaved", "saved", "setVote", "dir", "Lnet/dean/jraw/models/VoteDirection;", "unsave", "unvote", "upvote", "lib"})
public abstract class PublicContributionReference
extends ReplyableReference {
    @NotNull
    private final String fullName;
    @NotNull
    private final String id;

    @NotNull
    public final String getFullName() {
        return this.fullName;
    }

    public final void upvote() {
        this.setVote(VoteDirection.UP);
    }

    public final void downvote() {
        this.setVote(VoteDirection.DOWN);
    }

    public final void unvote() {
        this.setVote(VoteDirection.NONE);
    }

    @EndpointImplementation(endpoints={Endpoint.POST_VOTE})
    public final void setVote(@NotNull VoteDirection dir) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)((Object)dir), (String)"dir");
        switch (PublicContributionReference$WhenMappings.$EnumSwitchMapping$0[dir.ordinal()]) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 0;
                break;
            }
            case 3: {
                n = -1;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int value = n;
        this.getReddit().request((Function1<? super HttpRequest.Builder, HttpRequest.Builder>)((Function1)new Function1<HttpRequest.Builder, HttpRequest.Builder>(this, value){
            final /* synthetic */ PublicContributionReference this$0;
            final /* synthetic */ int $value;

            @NotNull
            public final HttpRequest.Builder invoke(@NotNull HttpRequest.Builder it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.endpoint(Endpoint.POST_VOTE, new String[0]).post(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"dir", (Object)String.valueOf(this.$value)), TuplesKt.to((Object)"id", (Object)this.this$0.getFullName())}));
            }
            {
                this.this$0 = publicContributionReference;
                this.$value = n;
                super(1);
            }
        }));
    }

    public final void save() {
        this.setSaved(true);
    }

    public final void unsave() {
        this.setSaved(false);
    }

    @EndpointImplementation(endpoints={Endpoint.POST_SAVE, Endpoint.POST_UNSAVE})
    public final void setSaved(boolean saved) {
        Endpoint endpoint = saved ? Endpoint.POST_SAVE : Endpoint.POST_UNSAVE;
        this.getReddit().request((Function1<? super HttpRequest.Builder, HttpRequest.Builder>)((Function1)new Function1<HttpRequest.Builder, HttpRequest.Builder>(this, endpoint){
            final /* synthetic */ PublicContributionReference this$0;
            final /* synthetic */ Endpoint $endpoint;

            @NotNull
            public final HttpRequest.Builder invoke(@NotNull HttpRequest.Builder it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.endpoint(this.$endpoint, new String[0]).post(MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)this.this$0.getFullName())));
            }
            {
                this.this$0 = publicContributionReference;
                this.$endpoint = endpoint;
                super(1);
            }
        }));
    }

    @NotNull
    public final Comment reply(@NotNull String text) throws ApiException {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Object comment = CollectionsKt.first(this.reply(this.fullName, text));
        Class<Enveloped> annotationType$iv = Enveloped.class;
        JsonAdapter jsonAdapter = JrawUtils.moshi.adapter((Type)((Object)Comment.class), annotationType$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"moshi.adapter(T::class.java, annotationType)");
        Object object = jsonAdapter.fromJsonValue(comment);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (Comment)object;
    }

    @EndpointImplementation(endpoints={Endpoint.POST_DEL})
    public final void delete() {
        this.getReddit().request((Function1<? super HttpRequest.Builder, HttpRequest.Builder>)((Function1)new Function1<HttpRequest.Builder, HttpRequest.Builder>(this){
            final /* synthetic */ PublicContributionReference this$0;

            @NotNull
            public final HttpRequest.Builder invoke(@NotNull HttpRequest.Builder it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.endpoint(Endpoint.POST_DEL, new String[0]).post(MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)this.this$0.getFullName())));
            }
            {
                this.this$0 = publicContributionReference;
                super(1);
            }
        }));
    }

    @EndpointImplementation(endpoints={Endpoint.POST_EDITUSERTEXT})
    public final void edit(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.getReddit().request((Function1<? super HttpRequest.Builder, HttpRequest.Builder>)((Function1)new Function1<HttpRequest.Builder, HttpRequest.Builder>(this, text){
            final /* synthetic */ PublicContributionReference this$0;
            final /* synthetic */ String $text;

            @NotNull
            public final HttpRequest.Builder invoke(@NotNull HttpRequest.Builder it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.endpoint(Endpoint.POST_EDITUSERTEXT, new String[0]).post(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"api_type", (Object)"json"), TuplesKt.to((Object)"text", (Object)this.$text), TuplesKt.to((Object)"thing_id", (Object)this.this$0.getFullName())}));
            }
            {
                this.this$0 = publicContributionReference;
                this.$text = string;
                super(1);
            }
        }));
    }

    @EndpointImplementation(endpoints={Endpoint.POST_SENDREPLIES})
    public final void sendReplies(boolean sendReplies2) {
        this.getReddit().request((Function1<? super HttpRequest.Builder, HttpRequest.Builder>)((Function1)new Function1<HttpRequest.Builder, HttpRequest.Builder>(this, sendReplies2){
            final /* synthetic */ PublicContributionReference this$0;
            final /* synthetic */ boolean $sendReplies;

            @NotNull
            public final HttpRequest.Builder invoke(@NotNull HttpRequest.Builder it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.endpoint(Endpoint.POST_SENDREPLIES, new String[0]).post(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"id", (Object)this.this$0.getFullName()), TuplesKt.to((Object)"state", (Object)String.valueOf(this.$sendReplies))}));
            }
            {
                this.this$0 = publicContributionReference;
                this.$sendReplies = bl;
                super(1);
            }
        }));
    }

    @EndpointImplementation(endpoints={Endpoint.POST_DISTINGUISH})
    public final void distinguish(@NotNull DistinguishedStatus how, boolean sticky) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)((Object)how), (String)"how");
        switch (PublicContributionReference$WhenMappings.$EnumSwitchMapping$1[how.ordinal()]) {
            case 1: {
                string = "no";
                break;
            }
            case 2: {
                string = "yes";
                break;
            }
            case 3: {
                string = "admin";
                break;
            }
            case 4: {
                string = "special";
                break;
            }
            case 5: {
                throw (Throwable)new IllegalArgumentException("Cannot manually distinguish a contribution with a gold distinguish status");
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String howOption = string;
        if (sticky && this instanceof SubmissionReference) {
            throw (Throwable)new IllegalArgumentException("Flag 'sticky' can only be set for comments, not submissions");
        }
        if (sticky && how == DistinguishedStatus.NORMAL) {
            throw (Throwable)new IllegalArgumentException("Cannot use flag 'sticky' with DistinguishedStatus.NORMAL");
        }
        this.getReddit().request((Function1<? super HttpRequest.Builder, HttpRequest.Builder>)((Function1)new Function1<HttpRequest.Builder, HttpRequest.Builder>(this, howOption, sticky){
            final /* synthetic */ PublicContributionReference this$0;
            final /* synthetic */ String $howOption;
            final /* synthetic */ boolean $sticky;

            @NotNull
            public final HttpRequest.Builder invoke(@NotNull HttpRequest.Builder it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.endpoint(Endpoint.POST_DISTINGUISH, new String[0]).post(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"api_type", (Object)"json"), TuplesKt.to((Object)"how", (Object)this.$howOption), TuplesKt.to((Object)"id", (Object)this.this$0.getFullName()), TuplesKt.to((Object)"sticky", (Object)String.valueOf(this.$sticky))}));
            }
            {
                this.this$0 = publicContributionReference;
                this.$howOption = string;
                this.$sticky = bl;
                super(1);
            }
        }));
    }

    @EndpointImplementation(endpoints={Endpoint.POST_REMOVE})
    @JvmOverloads
    public final void remove(boolean spam) {
        this.getReddit().request((Function1<? super HttpRequest.Builder, HttpRequest.Builder>)((Function1)new Function1<HttpRequest.Builder, HttpRequest.Builder>(this, spam){
            final /* synthetic */ PublicContributionReference this$0;
            final /* synthetic */ boolean $spam;

            @NotNull
            public final HttpRequest.Builder invoke(@NotNull HttpRequest.Builder it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.endpoint(Endpoint.POST_REMOVE, new String[0]).post(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"id", (Object)this.this$0.getFullName()), TuplesKt.to((Object)"spam", (Object)String.valueOf(this.$spam))}));
            }
            {
                this.this$0 = publicContributionReference;
                this.$spam = bl;
                super(1);
            }
        }));
    }

    @EndpointImplementation(endpoints={Endpoint.POST_REMOVE})
    @JvmOverloads
    public static /* bridge */ /* synthetic */ void remove$default(PublicContributionReference publicContributionReference, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: remove");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        publicContributionReference.remove(bl);
    }

    @EndpointImplementation(endpoints={Endpoint.POST_REMOVE})
    @JvmOverloads
    public final void remove() {
        PublicContributionReference.remove$default(this, false, 1, null);
    }

    @EndpointImplementation(endpoints={Endpoint.POST_APPROVE})
    public final void approve() {
        this.getReddit().request((Function1<? super HttpRequest.Builder, HttpRequest.Builder>)((Function1)new Function1<HttpRequest.Builder, HttpRequest.Builder>(this){
            final /* synthetic */ PublicContributionReference this$0;

            @NotNull
            public final HttpRequest.Builder invoke(@NotNull HttpRequest.Builder it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.endpoint(Endpoint.POST_APPROVE, new String[0]).post(MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)this.this$0.getFullName())));
            }
            {
                this.this$0 = publicContributionReference;
                super(1);
            }
        }));
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public PublicContributionReference(@NotNull RedditClient reddit, @NotNull String id, @NotNull String kindPrefix) {
        Intrinsics.checkParameterIsNotNull((Object)reddit, (String)"reddit");
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)kindPrefix, (String)"kindPrefix");
        super(reddit);
        this.id = id;
        this.fullName = "" + kindPrefix + '_' + this.id;
    }
}

