/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.references;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dean.jraw.ApiException;
import net.dean.jraw.Endpoint;
import net.dean.jraw.EndpointImplementation;
import net.dean.jraw.JrawUtils;
import net.dean.jraw.MethodType;
import net.dean.jraw.RedditClient;
import net.dean.jraw.SuspendedAccountException;
import net.dean.jraw.databind.Enveloped;
import net.dean.jraw.http.HttpRequest;
import net.dean.jraw.http.HttpResponse;
import net.dean.jraw.http.NetworkException;
import net.dean.jraw.models.Account;
import net.dean.jraw.models.AccountQuery;
import net.dean.jraw.models.AccountStatus;
import net.dean.jraw.models.Multireddit;
import net.dean.jraw.models.PublicContribution;
import net.dean.jraw.models.Trophy;
import net.dean.jraw.models.UserHistorySort;
import net.dean.jraw.models.internal.TrophyList;
import net.dean.jraw.pagination.DefaultPaginator;
import net.dean.jraw.references.AbstractReference;
import net.dean.jraw.references.MultiredditReference;
import net.dean.jraw.references.UserFlairReference;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B\u0017\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0007J\u0015\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\u0012J \u0010\u0013\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u0017\u001a\u00020\u0007H\u0007J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0007J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0007J\b\u0010\u001e\u001a\u00020\u001fH\u0007J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0019H\u0007R\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u0082\u0001\u0002\"#\u00a8\u0006$"}, d2={"Lnet/dean/jraw/references/UserReference;", "T", "Lnet/dean/jraw/references/UserFlairReference;", "Lnet/dean/jraw/references/AbstractReference;", "reddit", "Lnet/dean/jraw/RedditClient;", "username", "", "(Lnet/dean/jraw/RedditClient;Ljava/lang/String;)V", "isSelf", "", "()Z", "getUsername", "()Ljava/lang/String;", "about", "Lnet/dean/jraw/models/Account;", "flairOn", "subreddit", "(Ljava/lang/String;)Lnet/dean/jraw/references/UserFlairReference;", "history", "Lnet/dean/jraw/pagination/DefaultPaginator$Builder;", "Lnet/dean/jraw/models/PublicContribution;", "Lnet/dean/jraw/models/UserHistorySort;", "where", "listMultis", "", "Lnet/dean/jraw/models/Multireddit;", "multi", "Lnet/dean/jraw/references/MultiredditReference;", "name", "query", "Lnet/dean/jraw/models/AccountQuery;", "trophies", "Lnet/dean/jraw/models/Trophy;", "Lnet/dean/jraw/references/SelfUserReference;", "Lnet/dean/jraw/references/OtherUserReference;", "lib"})
public abstract class UserReference<T extends UserFlairReference>
extends AbstractReference {
    @NotNull
    private final String username;

    public abstract boolean isSelf();

    @Deprecated(message="Prefer query() for better handling of non-existent/suspended accounts", replaceWith=@ReplaceWith(imports={}, expression="query()"))
    @NotNull
    public final Account about() throws SuspendedAccountException {
        String body2 = this.getReddit().request((Function1<? super HttpRequest.Builder, HttpRequest.Builder>)((Function1)new Function1<HttpRequest.Builder, HttpRequest.Builder>(this){
            final /* synthetic */ UserReference this$0;

            @NotNull
            public final HttpRequest.Builder invoke(@NotNull HttpRequest.Builder it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.path(this.this$0.isSelf() ? "/api/v1/me" : "/user/" + this.this$0.getUsername() + "/about", new String[0]);
            }
            {
                this.this$0 = userReference;
                super(1);
            }
        })).getBody();
        if (this.isSelf()) {
            JsonAdapter jsonAdapter = JrawUtils.moshi.adapter(Account.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"moshi.adapter(T::class.java)");
            Object object = jsonAdapter.fromJson(body2);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            return (Account)object;
        }
        try {
            Class<Enveloped> annotationType$iv = Enveloped.class;
            JsonAdapter jsonAdapter = JrawUtils.moshi.adapter((Type)((Object)Account.class), annotationType$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"moshi.adapter(T::class.java, annotationType)");
            Object object = jsonAdapter.fromJson(body2);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            return (Account)object;
        }
        catch (NullPointerException npe) {
            throw (Throwable)new SuspendedAccountException(this.username, null, 2, null);
        }
    }

    @EndpointImplementation(endpoints={Endpoint.GET_ME, Endpoint.GET_USER_USERNAME_ABOUT})
    @NotNull
    public final AccountQuery query() {
        AccountQuery accountQuery;
        try {
            AccountQuery accountQuery2 = AccountQuery.create(this.username, AccountStatus.EXISTS, this.about());
            Intrinsics.checkExpressionValueIsNotNull((Object)accountQuery2, (String)"AccountQuery.create(user\u2026ntStatus.EXISTS, about())");
            accountQuery = accountQuery2;
        }
        catch (ApiException e) {
            if (e.getCause() instanceof NetworkException && ((NetworkException)e.getCause()).getRes().getCode() != 404) {
                throw (Throwable)e;
            }
            AccountQuery accountQuery3 = AccountQuery.create(this.username, AccountStatus.NON_EXISTENT);
            Intrinsics.checkExpressionValueIsNotNull((Object)accountQuery3, (String)"AccountQuery.create(user\u2026countStatus.NON_EXISTENT)");
            accountQuery = accountQuery3;
        }
        catch (SuspendedAccountException e) {
            AccountQuery accountQuery4 = AccountQuery.create(this.username, AccountStatus.SUSPENDED);
            Intrinsics.checkExpressionValueIsNotNull((Object)accountQuery4, (String)"AccountQuery.create(user\u2026 AccountStatus.SUSPENDED)");
            accountQuery = accountQuery4;
        }
        return accountQuery;
    }

    @EndpointImplementation(endpoints={Endpoint.GET_ME_TROPHIES, Endpoint.GET_USER_USERNAME_TROPHIES})
    @NotNull
    public final List<Trophy> trophies() {
        HttpResponse this_$iv = this.getReddit().request((Function1<? super HttpRequest.Builder, HttpRequest.Builder>)((Function1)new Function1<HttpRequest.Builder, HttpRequest.Builder>(this){
            final /* synthetic */ UserReference this$0;

            @NotNull
            public final HttpRequest.Builder invoke(@NotNull HttpRequest.Builder it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.this$0.isSelf() ? it.endpoint(Endpoint.GET_ME_TROPHIES, new String[0]) : it.endpoint(Endpoint.GET_USER_USERNAME_TROPHIES, this.this$0.getUsername());
            }
            {
                this.this$0 = userReference;
                super(1);
            }
        }));
        Class<Enveloped> annotationType$iv$iv = Enveloped.class;
        HttpResponse httpResponse = this_$iv;
        JsonAdapter jsonAdapter = JrawUtils.moshi.adapter((Type)((Object)TrophyList.class), annotationType$iv$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"moshi.adapter(T::class.java, annotationType)");
        JsonAdapter jsonAdapter2 = jsonAdapter;
        List<Trophy> list = ((TrophyList)httpResponse.deserializeWith(jsonAdapter2)).getTrophies();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"reddit.request {\n       \u2026ed<TrophyList>().trophies");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @EndpointImplementation(type=MethodType.NON_BLOCKING_CALL, endpoints={Endpoint.GET_USER_USERNAME_WHERE})
    @NotNull
    public final DefaultPaginator.Builder<PublicContribution<?>, UserHistorySort> history(@NotNull String where) {
        void sortingAlsoInPath$iv;
        void baseUrl$iv;
        void reddit$iv;
        Intrinsics.checkParameterIsNotNull((Object)where, (String)"where");
        DefaultPaginator.Builder.Companion companion = DefaultPaginator.Builder.Companion;
        RedditClient redditClient = this.getReddit();
        String string = "/user/" + JrawUtils.urlEncode(this.username) + '/' + JrawUtils.urlEncode(where);
        boolean bl = false;
        return new DefaultPaginator.Builder((RedditClient)reddit$iv, (String)baseUrl$iv, (boolean)sortingAlsoInPath$iv, PublicContribution.class);
    }

    @NotNull
    public final MultiredditReference multi(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return new MultiredditReference(this.getReddit(), this.username, name);
    }

    @EndpointImplementation(endpoints={Endpoint.GET_MULTI_MINE, Endpoint.GET_MULTI_USER_USERNAME})
    @NotNull
    public final List<Multireddit> listMultis() {
        JsonAdapter adapter;
        HttpResponse res2 = this.getReddit().request((Function1<? super HttpRequest.Builder, HttpRequest.Builder>)((Function1)new Function1<HttpRequest.Builder, HttpRequest.Builder>(this){
            final /* synthetic */ UserReference this$0;

            @NotNull
            public final HttpRequest.Builder invoke(@NotNull HttpRequest.Builder it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.this$0.isSelf() ? it.endpoint(Endpoint.GET_MULTI_MINE, new String[0]) : it.endpoint(Endpoint.GET_MULTI_USER_USERNAME, this.this$0.getUsername());
            }
            {
                this.this$0 = userReference;
                super(1);
            }
        }));
        ParameterizedType type = Types.newParameterizedType((Type)((Type)((Object)List.class)), (Type[])new Type[]{(Type)((Object)Multireddit.class)});
        JsonAdapter jsonAdapter = adapter = JrawUtils.moshi.adapter((Type)type, Enveloped.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"adapter");
        Object t = res2.deserializeWith(jsonAdapter);
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"res.deserializeWith(adapter)");
        return (List)t;
    }

    @NotNull
    public abstract T flairOn(@NotNull String var1);

    @NotNull
    public final String getUsername() {
        return this.username;
    }

    private UserReference(RedditClient reddit, String username) {
        super(reddit);
        this.username = username;
    }

    public /* synthetic */ UserReference(@NotNull RedditClient reddit, @NotNull String username, DefaultConstructorMarker $constructor_marker) {
        this(reddit, username);
    }
}

