/*
 * Decompiled with CFR 0.152.
 */
package net.dean.jraw.tree;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.dean.jraw.models.Listing;
import net.dean.jraw.models.NestedIdentifiable;
import net.dean.jraw.models.PublicContribution;
import net.dean.jraw.models.Submission;
import net.dean.jraw.references.CommentsRequest;
import net.dean.jraw.tree.AbstractCommentNode;
import net.dean.jraw.tree.CommentNode;
import net.dean.jraw.tree.CommentTreeSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lnet/dean/jraw/tree/RootCommentNode;", "Lnet/dean/jraw/tree/AbstractCommentNode;", "Lnet/dean/jraw/models/Submission;", "submission", "replies", "Lnet/dean/jraw/models/Listing;", "Lnet/dean/jraw/models/NestedIdentifiable;", "settings", "Lnet/dean/jraw/tree/CommentTreeSettings;", "(Lnet/dean/jraw/models/Submission;Lnet/dean/jraw/models/Listing;Lnet/dean/jraw/tree/CommentTreeSettings;)V", "depth", "", "getDepth", "()I", "parent", "Lnet/dean/jraw/tree/CommentNode;", "getParent", "()Lnet/dean/jraw/tree/CommentNode;", "lib"})
public final class RootCommentNode
extends AbstractCommentNode<Submission> {
    private final int depth = 0;

    @Override
    @NotNull
    public CommentNode<?> getParent() {
        throw (Throwable)new IllegalArgumentException("Root nodes have no parent node");
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    public RootCommentNode(@NotNull Submission submission, @NotNull Listing<NestedIdentifiable> replies, @Nullable CommentTreeSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)submission, (String)"submission");
        Intrinsics.checkParameterIsNotNull(replies, (String)"replies");
        PublicContribution publicContribution = submission;
        CommentTreeSettings commentTreeSettings = settings;
        if (commentTreeSettings == null) {
            String string = submission.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"submission.id");
            commentTreeSettings = new CommentTreeSettings(string, CommentsRequest.DEFAULT_COMMENT_SORT);
        }
        super(0, null, publicContribution, commentTreeSettings);
        this.initReplies((List<NestedIdentifiable>)replies);
    }
}

