/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout;

import net.deanly.structlayout.analysis.HexDumpUtil;
import net.deanly.structlayout.codec.decode.StructDecoder;
import net.deanly.structlayout.codec.encode.StructEncoder;

public class StructLayout {
    public static <T> byte[] encode(T object) {
        return StructEncoder.encode(object);
    }

    public static <T> T decode(byte[] data, Class<T> type) {
        return StructDecoder.decode(type, data, 0).getValue();
    }

    public static void debug(byte[] data) {
        if (data == null || data.length == 0) {
            System.out.println("[Empty byte array]");
            return;
        }
        String hexDump = HexDumpUtil.toHexDump(data);
        System.out.println(hexDump);
        System.out.println("Total Bytes: " + data.length);
    }

    public static void debug(Object obj) {
        if (obj == null) {
            System.out.println("[Object is null]");
            return;
        }
        try {
            StructEncoder.encodeWithDebug(obj);
        }
        catch (Exception e) {
            System.err.println("[Field Debug Error: " + e.getMessage() + "]");
        }
    }
}

