/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.analysis;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import net.deanly.structlayout.Field;
import net.deanly.structlayout.exception.LayoutInitializationException;
import net.deanly.structlayout.factory.ClassFactory;
import net.deanly.structlayout.type.DynamicSpanField;
import net.deanly.structlayout.type.FieldBase;
import net.deanly.structlayout.type.basic.BasicType;
import net.deanly.structlayout.type.basic.CharCField;
import net.deanly.structlayout.type.basic.Float32BEField;
import net.deanly.structlayout.type.basic.Float32LEField;
import net.deanly.structlayout.type.basic.Float64BEField;
import net.deanly.structlayout.type.basic.Float64LEField;
import net.deanly.structlayout.type.basic.Int16BEField;
import net.deanly.structlayout.type.basic.Int16LEField;
import net.deanly.structlayout.type.basic.Int32BEField;
import net.deanly.structlayout.type.basic.Int32LEField;
import net.deanly.structlayout.type.basic.Int64BEField;
import net.deanly.structlayout.type.basic.Int64LEField;
import net.deanly.structlayout.type.basic.Int8Field;
import net.deanly.structlayout.type.basic.UCharCField;
import net.deanly.structlayout.type.basic.UInt16BEField;
import net.deanly.structlayout.type.basic.UInt16LEField;
import net.deanly.structlayout.type.basic.UInt32BEField;
import net.deanly.structlayout.type.basic.UInt32LEField;
import net.deanly.structlayout.type.basic.UInt64BEField;
import net.deanly.structlayout.type.basic.UInt64LEField;
import net.deanly.structlayout.type.basic.UInt8Field;

public class CachedLayoutProvider {
    private static final Map<Class<? extends Field<?>>, Field<?>> layoutCache = new HashMap();

    public static <T> Field<T> getLayout(BasicType basicType) {
        try {
            if (!(basicType instanceof Field)) {
                throw new IllegalArgumentException("Provided BasicType does not implement Field: " + basicType.getClass().getName());
            }
            Class<?> fieldClass = basicType.getClass();
            return CachedLayoutProvider.getLayout(fieldClass);
        }
        catch (Exception e) {
            throw new LayoutInitializationException("Failed to create Layout for BasicType: " + basicType, e);
        }
    }

    public static <T> Field<T> getLayout(Class<? extends Field<?>> layoutClass) {
        Field<?> cachedField = layoutCache.get(layoutClass);
        if (cachedField != null) {
            return cachedField;
        }
        FieldBase field = ClassFactory.createLayoutInstance(layoutClass);
        if (!DynamicSpanField.class.isAssignableFrom(layoutClass)) {
            layoutCache.put(layoutClass, field);
        } else if (CachedLayoutProvider.isFinalSpanField(layoutClass)) {
            layoutCache.put(layoutClass, field);
        }
        return field;
    }

    private static boolean isFinalSpanField(Class<?> layoutClass) {
        try {
            java.lang.reflect.Field spanField = layoutClass.getDeclaredField("span");
            int modifiers = spanField.getModifiers();
            return Modifier.isFinal(modifiers);
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    static {
        layoutCache.put(UInt8Field.class, new UInt8Field());
        layoutCache.put(Int8Field.class, new Int8Field());
        layoutCache.put(UInt16LEField.class, new UInt16LEField());
        layoutCache.put(UInt16BEField.class, new UInt16BEField());
        layoutCache.put(Int16LEField.class, new Int16LEField());
        layoutCache.put(Int16BEField.class, new Int16BEField());
        layoutCache.put(UInt32LEField.class, new UInt32LEField());
        layoutCache.put(UInt32BEField.class, new UInt32BEField());
        layoutCache.put(Int32LEField.class, new Int32LEField());
        layoutCache.put(Int32BEField.class, new Int32BEField());
        layoutCache.put(UInt64LEField.class, new UInt64LEField());
        layoutCache.put(UInt64BEField.class, new UInt64BEField());
        layoutCache.put(Int64LEField.class, new Int64LEField());
        layoutCache.put(Int64BEField.class, new Int64BEField());
        layoutCache.put(Float32LEField.class, new Float32LEField());
        layoutCache.put(Float32BEField.class, new Float32BEField());
        layoutCache.put(Float64LEField.class, new Float64LEField());
        layoutCache.put(Float64BEField.class, new Float64BEField());
        layoutCache.put(CharCField.class, new CharCField());
        layoutCache.put(UCharCField.class, new UCharCField());
    }
}

