/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.analysis;

import java.util.Arrays;
import lombok.Generated;

public class FieldDebugInfo {
    private final String order;
    private final String orderPrefix;
    private final String orderSuffix;
    private final String fieldName;
    private final byte[] encodedBytes;

    public String getEncodedBytesHex() {
        StringBuilder hex = new StringBuilder();
        for (byte b : this.encodedBytes) {
            hex.append(String.format("%02X ", b));
        }
        return hex.toString().trim();
    }

    public String getOrderString() {
        return (this.orderPrefix == null ? "" : this.orderPrefix) + this.order + (this.orderSuffix == null ? "" : this.orderSuffix);
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public String getOrder() {
        return this.order;
    }

    @Generated
    public String getOrderPrefix() {
        return this.orderPrefix;
    }

    @Generated
    public String getOrderSuffix() {
        return this.orderSuffix;
    }

    @Generated
    public String getFieldName() {
        return this.fieldName;
    }

    @Generated
    public byte[] getEncodedBytes() {
        return this.encodedBytes;
    }

    @Generated
    public FieldDebugInfo(String order, String orderPrefix, String orderSuffix, String fieldName, byte[] encodedBytes) {
        this.order = order;
        this.orderPrefix = orderPrefix;
        this.orderSuffix = orderSuffix;
        this.fieldName = fieldName;
        this.encodedBytes = encodedBytes;
    }

    @Generated
    public static class Builder {
        @Generated
        private String order;
        @Generated
        private String orderPrefix;
        @Generated
        private String orderSuffix;
        @Generated
        private String fieldName;
        @Generated
        private byte[] encodedBytes;

        @Generated
        Builder() {
        }

        @Generated
        public Builder order(String order) {
            this.order = order;
            return this;
        }

        @Generated
        public Builder orderPrefix(String orderPrefix) {
            this.orderPrefix = orderPrefix;
            return this;
        }

        @Generated
        public Builder orderSuffix(String orderSuffix) {
            this.orderSuffix = orderSuffix;
            return this;
        }

        @Generated
        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        @Generated
        public Builder encodedBytes(byte[] encodedBytes) {
            this.encodedBytes = encodedBytes;
            return this;
        }

        @Generated
        public FieldDebugInfo build() {
            return new FieldDebugInfo(this.order, this.orderPrefix, this.orderSuffix, this.fieldName, this.encodedBytes);
        }

        @Generated
        public String toString() {
            return "FieldDebugInfo.Builder(order=" + this.order + ", orderPrefix=" + this.orderPrefix + ", orderSuffix=" + this.orderSuffix + ", fieldName=" + this.fieldName + ", encodedBytes=" + Arrays.toString(this.encodedBytes) + ")";
        }
    }
}

