/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.analysis;

public class HexDumpUtil {
    public static String toHexDump(byte[] data) {
        StringBuilder hexDump = new StringBuilder();
        int length = data.length;
        for (int offset = 0; offset < length; offset += 16) {
            int i;
            if (offset != 0) {
                hexDump.append(System.lineSeparator());
            }
            hexDump.append(String.format("%08x: ", offset));
            for (i = 0; i < 16; ++i) {
                if (offset + i < length) {
                    hexDump.append(String.format("%02x ", data[offset + i]));
                    continue;
                }
                hexDump.append("   ");
            }
            hexDump.append("  ");
            for (i = 0; i < 16; ++i) {
                if (offset + i >= length) continue;
                byte b = data[offset + i];
                char c = (char)b;
                if (c >= ' ' && c <= '~') {
                    hexDump.append(c);
                    continue;
                }
                hexDump.append('.');
            }
        }
        return hexDump.toString();
    }
}

