/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.codec.decode;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.deanly.structlayout.analysis.DecodedFieldInfo;
import net.deanly.structlayout.codec.decode.FieldProcessor;
import net.deanly.structlayout.codec.decode.StructDecodeResult;
import net.deanly.structlayout.codec.helpers.FieldHelper;
import net.deanly.structlayout.exception.InvalidDataOffsetException;
import net.deanly.structlayout.exception.StructDecodingException;
import net.deanly.structlayout.factory.ClassFactory;
import net.deanly.structlayout.support.Tuple2;

public class StructDecoder {
    public static <T> StructDecodeResult<T> decode(Class<T> type, byte[] data, int startOffset) {
        if (startOffset < 0 || startOffset >= data.length) {
            throw new InvalidDataOffsetException(startOffset, data.length);
        }
        T instance = ClassFactory.createNoArgumentsInstance(type);
        List<Field> allFields = FieldHelper.getAllDeclaredFieldsIncludingSuperclasses(type);
        List<Field> orderedFields = FieldHelper.getOrderedFields(allFields);
        int offset = startOffset;
        for (Field field : orderedFields) {
            try {
                offset += FieldProcessor.processField(instance, field, data, offset);
            }
            catch (Exception ex) {
                List<DecodedFieldInfo> decodedInfos = StructDecoder.collectDecodedFields(type, data, startOffset, field);
                throw new StructDecodingException(type, field, offset, decodedInfos, ex);
            }
        }
        return StructDecodeResult.of(instance, offset - startOffset);
    }

    private static <T> List<DecodedFieldInfo> collectDecodedFields(Class<T> type, byte[] data, int startOffset, Field failedField) {
        List<Field> allFields = FieldHelper.getAllDeclaredFieldsIncludingSuperclasses(type);
        List<Tuple2<Field, Integer>> orderedFields = FieldHelper.getOrderedFieldsWithOrder(allFields);
        T instance = ClassFactory.createNoArgumentsInstance(type);
        int offset = startOffset;
        ArrayList<DecodedFieldInfo> decodedInfos = new ArrayList<DecodedFieldInfo>();
        for (Tuple2<Field, Integer> tuple : orderedFields) {
            Field field = (Field)tuple.first;
            int order = (Integer)tuple.second;
            if (field.equals(failedField)) break;
            try {
                int before = offset;
                int consumed = FieldProcessor.processField(instance, field, data, offset);
                offset += consumed;
                byte[] fieldBytes = Arrays.copyOfRange(data, before, before + consumed);
                decodedInfos.add(new DecodedFieldInfo(field.getName(), order, before, fieldBytes));
            }
            catch (Exception ignored) {
                break;
            }
        }
        return decodedInfos;
    }
}

