/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.codec.decode.handler;

import net.deanly.structlayout.Field;
import net.deanly.structlayout.annotation.OptionalEncoding;
import net.deanly.structlayout.annotation.StructField;
import net.deanly.structlayout.codec.decode.handler.BaseFieldHandler;
import net.deanly.structlayout.codec.helpers.TypeConverterHelper;
import net.deanly.structlayout.type.DynamicSpanField;

public class StructFieldHandler
extends BaseFieldHandler {
    @Override
    public <T> int handleField(T instance, java.lang.reflect.Field field, byte[] data, int offset) throws IllegalAccessException {
        StructField annotation = field.getAnnotation(StructField.class);
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Field '%s' is not annotated with @CustomLayoutField", field.getName()));
        }
        OptionalEncoding optional = annotation.optional();
        if (optional == OptionalEncoding.BORSH) {
            if (!this.isValuePresent(data, offset, optional)) {
                field.setAccessible(true);
                field.set(instance, null);
                return 1;
            }
            ++offset;
        }
        Field<?> layout = this.createLayoutInstance(annotation.type());
        Object decodedValue = layout.decode(data, offset);
        Object targetValue = TypeConverterHelper.convertToType(decodedValue, field.getType());
        field.setAccessible(true);
        field.set(instance, targetValue);
        if (layout instanceof DynamicSpanField) {
            return ((DynamicSpanField)((Object)layout)).calculateSpan(data, offset) + (optional == OptionalEncoding.BORSH ? 1 : 0);
        }
        return layout.getSpan() + (optional == OptionalEncoding.BORSH ? 1 : 0);
    }

    private Field<?> createLayoutInstance(Class<? extends Field<?>> layoutClass) {
        try {
            return layoutClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Failed to instantiate custom layout class '%s'", layoutClass.getName()), e);
        }
    }
}

