/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.codec.decode.handler;

import java.lang.reflect.Field;
import net.deanly.structlayout.annotation.OptionalEncoding;
import net.deanly.structlayout.annotation.StructObjectField;
import net.deanly.structlayout.annotation.StructTypeSelector;
import net.deanly.structlayout.codec.decode.StructDecodeResult;
import net.deanly.structlayout.codec.decode.StructDecoder;
import net.deanly.structlayout.codec.decode.handler.BaseFieldHandler;
import net.deanly.structlayout.dispatcher.StructTypeResolver;
import net.deanly.structlayout.exception.LayoutInitializationException;

public class StructObjectFieldHandler
extends BaseFieldHandler {
    @Override
    public <T> int handleField(T instance, Field field, byte[] data, int offset) throws IllegalAccessException {
        StructDecodeResult<Object> result;
        Class<?> nestedType;
        StructTypeSelector nestedTypeAnnotation;
        StructObjectField annotation = field.getAnnotation(StructObjectField.class);
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Field '%s' is not annotated with @StructObjectField", field.getName()));
        }
        OptionalEncoding optionalEncoding = annotation.optional();
        int consumed = 0;
        if (optionalEncoding == OptionalEncoding.BORSH) {
            boolean isPresent = this.isValuePresent(data, offset, optionalEncoding);
            ++consumed;
            if (!isPresent) {
                field.setAccessible(true);
                field.set(instance, null);
                return consumed;
            }
            ++offset;
        }
        if ((nestedTypeAnnotation = (nestedType = field.getType()).getAnnotation(StructTypeSelector.class)) != null && nestedType.isInterface()) {
            try {
                if (data.length - offset == 0 && StructTypeResolver.resolveNoDataSpan(nestedType) == 0) {
                    return 0;
                }
                Class implClazz = StructTypeResolver.resolveClass(data, nestedType, offset);
                result = StructDecoder.decode(implClazz, data, offset);
            }
            catch (Exception e) {
                throw new LayoutInitializationException("Failed to dispatch interface: `" + nestedType.getName() + "` => " + e.getMessage(), e);
            }
        } else {
            result = StructDecoder.decode(nestedType, data, offset);
        }
        field.setAccessible(true);
        field.set(instance, result.getValue());
        return consumed + result.getSize();
    }
}

