/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.codec.decode.handler;

import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import net.deanly.structlayout.Field;
import net.deanly.structlayout.annotation.OptionalEncoding;
import net.deanly.structlayout.annotation.StructSequenceField;
import net.deanly.structlayout.codec.decode.handler.BaseFieldHandler;
import net.deanly.structlayout.codec.helpers.TypeConverterHelper;
import net.deanly.structlayout.exception.InvalidSequenceTypeException;
import net.deanly.structlayout.exception.LayoutInitializationException;
import net.deanly.structlayout.type.DynamicSpanField;
import net.deanly.structlayout.type.advanced.NoneField;

public class StructSequenceFieldHandler
extends BaseFieldHandler {
    @Override
    public <T> int handleField(T instance, java.lang.reflect.Field field, byte[] data, int offset) throws IllegalAccessException {
        int elementCount;
        Field<?> elementField;
        Collection<Object> result;
        Class<?> elementType;
        int length;
        StructSequenceField annotation = field.getAnnotation(StructSequenceField.class);
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Field '%s' is not annotated with @SequenceField", field.getName()));
        }
        OptionalEncoding optionalEncoding = annotation.optional();
        int consumed = 0;
        if (optionalEncoding == OptionalEncoding.BORSH) {
            boolean isPresent = this.isValuePresent(data, offset, optionalEncoding);
            ++consumed;
            if (!isPresent) {
                field.setAccessible(true);
                field.set(instance, null);
                return consumed;
            }
            ++offset;
        }
        Field<Object> lengthField = this.resolveLayout(annotation.lengthType());
        Class<Field<?>> elementFieldClass = annotation.elementType();
        boolean unsafeMode = lengthField instanceof NoneField;
        if (unsafeMode) {
            length = -1;
        } else {
            Object rawLengthValue = lengthField.decode(data, offset);
            length = (Integer)TypeConverterHelper.convertToType(rawLengthValue, Integer.class);
        }
        int currentOffset = offset + (lengthField instanceof DynamicSpanField ? ((DynamicSpanField)((Object)lengthField)).calculateSpan(data, offset) : lengthField.getSpan());
        Class<?> fieldType = field.getType();
        if (fieldType.isArray()) {
            elementType = fieldType.getComponentType();
            result = !unsafeMode ? Array.newInstance(elementType, length) : new ArrayList();
        } else if (Collection.class.isAssignableFrom(fieldType)) {
            elementType = this.resolveCollectionElementType(field);
            result = this.createCollectionInstance(fieldType);
        } else {
            throw new InvalidSequenceTypeException(fieldType.getName(), fieldType, "Only Array or Collection types are allowed.");
        }
        try {
            Field<?> elementFieldWildcard;
            elementField = elementFieldWildcard = elementFieldClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new LayoutInitializationException("Failed to initialize Field for elementType", ex);
        }
        for (elementCount = 0; unsafeMode && currentOffset < data.length || !unsafeMode && elementCount < length; ++elementCount) {
            Object rawElement = elementField.decode(data, currentOffset);
            int expectedSpan = elementField instanceof DynamicSpanField ? ((DynamicSpanField)((Object)elementField)).calculateSpan(data, currentOffset) : elementField.getSpan();
            if (expectedSpan == 0) {
                throw new IllegalStateException(String.format("Failed to decode data at offset %d. The decoding process returned zero span. This indicates that parsing the given data (%s) into an instance of '%s' is not possible or the input data is corrupted.", currentOffset, Arrays.toString(data), elementType != null ? elementType.getCanonicalName() : "Unknown Type"));
            }
            currentOffset += expectedSpan;
            if (rawElement == null) continue;
            Object convertedElement = TypeConverterHelper.convertToType(rawElement, elementType);
            if (fieldType.isArray() && !unsafeMode) {
                Array.set(result, elementCount, convertedElement);
                continue;
            }
            result.add(convertedElement);
        }
        field.setAccessible(true);
        if (unsafeMode && fieldType.isArray()) {
            Object arrayResult = Array.newInstance(elementType, elementCount);
            List tempList = (List)result;
            for (int i = 0; i < elementCount; ++i) {
                Array.set(arrayResult, i, tempList.get(i));
            }
            field.set(instance, arrayResult);
        } else {
            field.set(instance, result);
        }
        return consumed + (currentOffset - offset);
    }

    private Class<?> resolveCollectionElementType(java.lang.reflect.Field field) {
        ParameterizedType parameterizedType;
        if (field.getGenericType() instanceof ParameterizedType && (parameterizedType = (ParameterizedType)field.getGenericType()).getActualTypeArguments().length > 0) {
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        return Object.class;
    }

    private Collection<Object> createCollectionInstance(Class<?> fieldType) {
        if (List.class.isAssignableFrom(fieldType)) {
            return new ArrayList<Object>();
        }
        if (Set.class.isAssignableFrom(fieldType)) {
            return new HashSet<Object>();
        }
        if (Queue.class.isAssignableFrom(fieldType)) {
            return new LinkedList<Object>();
        }
        throw new IllegalArgumentException(String.format("Unsupported collection type '%s'. Only List, Set, and Queue are supported.", fieldType.getName()));
    }
}

