/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.codec.decode.handler;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.deanly.structlayout.Field;
import net.deanly.structlayout.annotation.OptionalEncoding;
import net.deanly.structlayout.annotation.StructSequenceObjectField;
import net.deanly.structlayout.annotation.StructTypeSelector;
import net.deanly.structlayout.codec.decode.StructDecodeResult;
import net.deanly.structlayout.codec.decode.StructDecoder;
import net.deanly.structlayout.codec.decode.handler.BaseFieldHandler;
import net.deanly.structlayout.codec.helpers.FieldHelper;
import net.deanly.structlayout.codec.helpers.TypeConverterHelper;
import net.deanly.structlayout.dispatcher.StructTypeResolver;
import net.deanly.structlayout.exception.InvalidAnnotationUsageException;
import net.deanly.structlayout.exception.InvalidSequenceTypeException;
import net.deanly.structlayout.exception.LayoutInitializationException;
import net.deanly.structlayout.type.DynamicSpanField;
import net.deanly.structlayout.type.advanced.NoneField;

public class StructSequenceObjectFieldHandler
extends BaseFieldHandler {
    @Override
    public <T> int handleField(T instance, java.lang.reflect.Field field, byte[] data, int offset) throws IllegalAccessException {
        Collection<Object> result;
        Class<?> fieldType;
        StructSequenceObjectField annotation = field.getAnnotation(StructSequenceObjectField.class);
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Field '%s' is not annotated with @StructSequenceObjectField", field.getName()));
        }
        OptionalEncoding optionalEncoding = annotation.optional();
        int consumed = 0;
        if (optionalEncoding == OptionalEncoding.BORSH) {
            boolean isPresent = this.isValuePresent(data, offset, optionalEncoding);
            ++consumed;
            if (!isPresent) {
                field.setAccessible(true);
                field.set(instance, null);
                return consumed;
            }
            ++offset;
        }
        Field<Object> lengthField = this.resolveLayout(annotation.lengthType());
        boolean unsafeMode = lengthField instanceof NoneField;
        int currentOffset = offset;
        int length = 0;
        if (!unsafeMode) {
            Object lengthRawValue = lengthField.decode(data, offset);
            length = (Integer)TypeConverterHelper.convertToType(lengthRawValue, Integer.class);
            currentOffset += lengthField instanceof DynamicSpanField ? ((DynamicSpanField)((Object)lengthField)).calculateSpan(data, offset) : lengthField.getSpan();
        }
        if (!(fieldType = field.getType()).isArray() && !Collection.class.isAssignableFrom(fieldType)) {
            throw new InvalidSequenceTypeException(field.getName(), fieldType, "Only Array or Collection types are supported for @StructSequenceObjectField");
        }
        Class<Object> elementType = fieldType.isArray() ? fieldType.getComponentType() : this.resolveCollectionElementType(field);
        Class<?> elementOriginType = elementType;
        if (fieldType.isArray()) {
            result = !unsafeMode ? Array.newInstance(elementOriginType, length) : new ArrayList();
        } else if (Collection.class.isAssignableFrom(fieldType)) {
            result = this.createCollectionInstance(fieldType);
        } else {
            throw new InvalidSequenceTypeException(field.getName(), fieldType, "Only Array or Collection types are supported for @StructSequenceObjectField");
        }
        if (!unsafeMode && length == 0) {
            field.setAccessible(true);
            if (fieldType.isArray()) {
                field.set(instance, Array.newInstance(elementType, 0));
            } else {
                field.set(instance, result);
            }
            return consumed + (currentOffset - offset);
        }
        if (elementType.isAnnotationPresent(StructTypeSelector.class)) {
            try {
                elementType = StructTypeResolver.resolveClass(data, elementOriginType, currentOffset);
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Failed to resolve element type for field '%s'. Type resolution error: %s", field.getName(), e.getMessage()), e);
            }
        }
        if (elementType.isPrimitive() || FieldHelper.PRIMITIVE_WRAPPERS.contains(elementType)) {
            throw new InvalidAnnotationUsageException(String.format("Field '%s' uses @StructSequenceObjectField but the element type '%s' is a primitive type. Use @StructSequenceField instead.", field.getName(), elementType.getName()));
        }
        if (!this.hasPublicNoArgsConstructor(elementType)) {
            throw new LayoutInitializationException(String.format("The Layout class '%s' must have a public no-arguments constructor. Check field '%s'.", elementType.getName(), field.getName()));
        }
        int elementCount = 0;
        while (unsafeMode ? currentOffset < data.length : elementCount < length) {
            if (!elementType.equals(elementOriginType)) {
                try {
                    elementType = StructTypeResolver.resolveClass(data, elementOriginType, currentOffset);
                }
                catch (Exception e) {
                    throw new IllegalStateException(String.format("Failed to resolve element type for field '%s'. Type resolution error: %s", field.getName(), e.getMessage()), e);
                }
            }
            StructDecodeResult<Object> decodeResult = StructDecoder.decode(elementType, data, currentOffset);
            Object decodedValue = decodeResult.getValue();
            int decodedSize = decodeResult.getSize();
            if (decodedValue == null || decodedSize == 0) {
                throw new IllegalStateException(String.format("Failed to decode data at offset %d. The decoding process returned null. This indicates that parsing the given data (%s) into an instance of '%s' is not possible or the input data is corrupted.", currentOffset, Arrays.toString(data), elementType != null ? elementType.getCanonicalName() : "Unknown Type"));
            }
            if (fieldType.isArray()) {
                if (unsafeMode) {
                    ((List)result).add(decodedValue);
                } else {
                    Array.set(result, elementCount, decodedValue);
                }
            } else {
                result.add(decodedValue);
            }
            currentOffset += decodedSize;
            ++elementCount;
        }
        field.setAccessible(true);
        if (unsafeMode && fieldType.isArray()) {
            Object arrayResult = Array.newInstance(elementType, elementCount);
            List tempList = (List)result;
            for (int i = 0; i < elementCount; ++i) {
                Array.set(arrayResult, i, tempList.get(i));
            }
            field.set(instance, arrayResult);
        } else {
            field.set(instance, result);
        }
        return consumed + (currentOffset - offset);
    }

    private boolean hasPublicNoArgsConstructor(Class<?> clazz) {
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            return Modifier.isPublic(constructor.getModifiers());
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private Class<?> resolveCollectionElementType(java.lang.reflect.Field field) {
        ParameterizedType parameterizedType;
        if (field.getGenericType() instanceof ParameterizedType && (parameterizedType = (ParameterizedType)field.getGenericType()).getActualTypeArguments().length > 0) {
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        return Object.class;
    }

    private Collection<Object> createCollectionInstance(Class<?> fieldType) {
        if (List.class.isAssignableFrom(fieldType)) {
            return new ArrayList<Object>();
        }
        throw new IllegalArgumentException(String.format("Unsupported collection type '%s'. Only List is currently supported.", fieldType.getName()));
    }
}

