/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.codec.encode;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.deanly.structlayout.analysis.FieldDebugInfo;
import net.deanly.structlayout.annotation.StructField;
import net.deanly.structlayout.annotation.StructObjectField;
import net.deanly.structlayout.annotation.StructSequenceField;
import net.deanly.structlayout.annotation.StructSequenceObjectField;
import net.deanly.structlayout.codec.encode.handler.BaseFieldHandler;
import net.deanly.structlayout.codec.encode.handler.StructFieldHandler;
import net.deanly.structlayout.codec.encode.handler.StructObjectFieldHandler;
import net.deanly.structlayout.codec.encode.handler.StructSequenceFieldHandler;
import net.deanly.structlayout.codec.encode.handler.StructSequenceObjectFieldHandler;
import net.deanly.structlayout.codec.helpers.FieldHelper;
import net.deanly.structlayout.exception.FieldAccessException;
import net.deanly.structlayout.exception.StructParsingException;
import net.deanly.structlayout.exception.TypeConversionException;

public class FieldProcessor {
    private static final Map<Class<? extends Annotation>, BaseFieldHandler> HANDLERS = new HashMap<Class<? extends Annotation>, BaseFieldHandler>();

    public static <T> byte[] processField(T instance, Field field) {
        for (Map.Entry<Class<? extends Annotation>, BaseFieldHandler> entry : HANDLERS.entrySet()) {
            if (!field.isAnnotationPresent(entry.getKey())) continue;
            try {
                return entry.getValue().handleField(instance, field);
            }
            catch (IllegalAccessException e) {
                throw new FieldAccessException(field.getName(), field.getClass().getSimpleName(), e);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Failed to process field: `" + field.getName() + "` => " + e.getMessage(), e);
            }
            catch (TypeConversionException e) {
                throw new TypeConversionException("Failed to process field: `" + field.getName() + "` => " + e.getMessage(), e);
            }
            catch (StructParsingException e) {
                throw e;
            }
            catch (InstantiationException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
                throw new StructParsingException("Failed to process field: `" + field.getName() + "` => " + e.getMessage(), e);
            }
        }
        throw new IllegalArgumentException("No handler found for field: `" + field.getName() + "`");
    }

    public static <T> List<FieldDebugInfo> processFieldRecursivelyWithDebug(T instance, Field field, String parentOrder) {
        ArrayList<FieldDebugInfo> debugInfos = new ArrayList<FieldDebugInfo>();
        for (Map.Entry<Class<? extends Annotation>, BaseFieldHandler> entry : HANDLERS.entrySet()) {
            if (!field.isAnnotationPresent(entry.getKey())) continue;
            try {
                Object order;
                Object object = order = parentOrder == null ? String.valueOf(FieldHelper.getOrderValue(field)) : parentOrder + "-" + FieldHelper.getOrderValue(field);
                if (field.isAnnotationPresent(StructObjectField.class)) {
                    Object childInstance = field.get(instance);
                    Class<?> fieldType = field.getType();
                    if ((fieldType.isInterface() || Modifier.isAbstract(fieldType.getModifiers())) && childInstance != null) {
                        fieldType = childInstance.getClass();
                    }
                    if (childInstance != null) {
                        Field[] childFields;
                        for (Field childField : childFields = fieldType.getDeclaredFields()) {
                            childField.setAccessible(true);
                            debugInfos.addAll(FieldProcessor.processFieldRecursivelyWithDebug(childInstance, childField, (String)order));
                        }
                    }
                } else if (field.isAnnotationPresent(StructSequenceObjectField.class)) {
                    List<FieldDebugInfo.Builder> builders = entry.getValue().handleDebug(instance, field);
                    for (FieldDebugInfo.Builder builder : builders) {
                        builder.order((String)order);
                        debugInfos.add(builder.build());
                    }
                } else if (field.isAnnotationPresent(StructSequenceField.class)) {
                    List<FieldDebugInfo.Builder> builders = entry.getValue().handleDebug(instance, field);
                    for (FieldDebugInfo.Builder builder : builders) {
                        builder.order((String)order);
                        debugInfos.add(builder.build());
                    }
                } else if (field.isAnnotationPresent(StructField.class)) {
                    FieldDebugInfo.Builder builder = entry.getValue().handleDebug(instance, field).get(0);
                    builder.order((String)order);
                    debugInfos.add(builder.build());
                }
                return debugInfos;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to debug field: `" + field.getName() + "` -> " + e.getMessage(), e);
            }
        }
        return debugInfos;
    }

    static {
        HANDLERS.put(StructField.class, new StructFieldHandler());
        HANDLERS.put(StructSequenceField.class, new StructSequenceFieldHandler());
        HANDLERS.put(StructObjectField.class, new StructObjectFieldHandler());
        HANDLERS.put(StructSequenceObjectField.class, new StructSequenceObjectFieldHandler());
    }
}

