/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.codec.encode;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.deanly.structlayout.analysis.FieldDebugInfo;
import net.deanly.structlayout.codec.encode.FieldProcessor;
import net.deanly.structlayout.codec.helpers.ByteArrayHelper;
import net.deanly.structlayout.codec.helpers.FieldHelper;

public class StructEncoder {
    public static <T> byte[] encode(T instance) {
        if (instance == null) {
            return new byte[0];
        }
        List<Field> allFields = StructEncoder.getAllDeclaredFields(instance.getClass());
        List<Field> orderedFields = FieldHelper.getOrderedFields(allFields);
        ArrayList<byte[]> fieldChunks = new ArrayList<byte[]>();
        for (Field field : orderedFields) {
            field.setAccessible(true);
            byte[] chunk = FieldProcessor.processField(instance, field);
            fieldChunks.add(chunk);
        }
        return ByteArrayHelper.mergeChunks(fieldChunks);
    }

    private static List<Field> getAllDeclaredFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null && clazz != Object.class) {
            Field[] declaredFields;
            for (Field field : declaredFields = clazz.getDeclaredFields()) {
                if (!FieldHelper.isStructField(field)) continue;
                fields.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    public static <T> void encodeWithDebug(T instance) {
        if (instance == null) {
            return;
        }
        List<Field> allFields = StructEncoder.getAllDeclaredFields(instance.getClass());
        List<Field> orderedFields = FieldHelper.getOrderedFields(allFields);
        ArrayList<FieldDebugInfo> debugInfos = new ArrayList<FieldDebugInfo>();
        for (Field field : orderedFields) {
            field.setAccessible(true);
            debugInfos.addAll(FieldProcessor.processFieldRecursivelyWithDebug(instance, field, null));
        }
        StructEncoder.printDebugInfo(debugInfos);
    }

    private static void printDebugInfo(List<FieldDebugInfo> debugInfos) {
        int offset = 0;
        int totalBytes = 0;
        int maxOrderLength = "Order".length();
        int maxFieldNameLength = "Field".length();
        int maxOffsetLength = "Offset".length();
        for (FieldDebugInfo info : debugInfos) {
            maxOrderLength = Math.max(maxOrderLength, info.getOrderString().length());
            maxFieldNameLength = Math.max(maxFieldNameLength, info.getFieldName().length());
            maxOffsetLength = Math.max(maxOffsetLength, String.format("%07d", offset).length());
            offset += info.getEncodedBytes().length;
        }
        System.out.printf("%-" + maxOrderLength + "s %-" + maxFieldNameLength + "s %-" + maxOffsetLength + "s %s%n", "Order", "Field", "Offset", "Bytes (HEX)");
        System.out.println("=".repeat(maxOrderLength + maxFieldNameLength + maxOffsetLength + 20));
        offset = 0;
        for (FieldDebugInfo info : debugInfos) {
            System.out.printf("%-" + maxOrderLength + "s %-" + maxFieldNameLength + "s %0" + maxOffsetLength + "d %s%n", info.getOrderString(), info.getFieldName(), offset, info.getEncodedBytesHex());
            offset += info.getEncodedBytes().length;
            totalBytes += info.getEncodedBytes().length;
        }
        System.out.println("=".repeat(maxOrderLength + maxFieldNameLength + maxOffsetLength + 20));
        System.out.printf("Total Bytes: %d%n", totalBytes);
    }
}

