/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.codec.encode.handler;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.deanly.structlayout.Field;
import net.deanly.structlayout.analysis.CachedLayoutProvider;
import net.deanly.structlayout.analysis.FieldDebugInfo;
import net.deanly.structlayout.codec.helpers.TypeConverterHelper;
import net.deanly.structlayout.type.FieldBase;

public abstract class BaseFieldHandler {
    public abstract <T> byte[] handleField(T var1, java.lang.reflect.Field var2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException;

    protected Field<Object> resolveLayout(Class<? extends Field<?>> basicType) {
        return CachedLayoutProvider.getLayout(basicType);
    }

    protected byte[] encodeElement(Class<? extends Field<?>> elementFieldType, Object element) {
        Field<Object> elementField = CachedLayoutProvider.getLayout(elementFieldType);
        Object convertedElement = TypeConverterHelper.convertToLayoutType(element, elementFieldType);
        return elementField.encode(convertedElement);
    }

    protected Object extractFieldValue(Object instance, java.lang.reflect.Field field) throws IllegalAccessException {
        return field.get(instance);
    }

    protected Object validateAndConvert(Object value, Class<? extends Field<?>> basicType, java.lang.reflect.Field field) {
        try {
            return TypeConverterHelper.convertToLayoutType(value, basicType);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid value for field " + field.getName() + ": " + e.getMessage(), e);
        }
    }

    protected Object handleNullValue(Class<? extends Field<?>> basicType) {
        if (FieldBase.isNumericType(basicType)) {
            return 0;
        }
        if (FieldBase.isStringType(basicType)) {
            return "";
        }
        throw new IllegalArgumentException("Field value cannot be null for Field: " + basicType);
    }

    public abstract <T> List<FieldDebugInfo.Builder> handleDebug(T var1, java.lang.reflect.Field var2) throws IllegalAccessException;
}

