/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.codec.encode.handler;

import java.util.List;
import net.deanly.structlayout.Field;
import net.deanly.structlayout.analysis.FieldDebugInfo;
import net.deanly.structlayout.annotation.OptionalEncoding;
import net.deanly.structlayout.annotation.StructField;
import net.deanly.structlayout.codec.encode.handler.BaseFieldHandler;
import net.deanly.structlayout.codec.helpers.TypeConverterHelper;
import net.deanly.structlayout.type.DynamicSpanField;

public class StructFieldHandler
extends BaseFieldHandler {
    @Override
    public <T> byte[] handleField(T instance, java.lang.reflect.Field field) throws IllegalAccessException {
        StructField annotation = field.getAnnotation(StructField.class);
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Field '%s' is not annotated with @StructField", field.getName()));
        }
        Class<? extends Field<?>> layoutClass = annotation.type();
        Field<Object> layout = this.createLayoutInstance(layoutClass, field.getName());
        Object value = this.extractFieldValue(instance, field);
        OptionalEncoding opt = annotation.optional();
        if (opt == OptionalEncoding.BORSH) {
            if (value == null) {
                return new byte[]{0};
            }
            Object converted = TypeConverterHelper.convertToLayoutType(value, layoutClass);
            byte[] encoded = layout.encode(converted);
            byte[] result = new byte[1 + encoded.length];
            result[0] = 1;
            System.arraycopy(encoded, 0, result, 1, encoded.length);
            return result;
        }
        if (value == null) {
            if (layout instanceof DynamicSpanField) {
                return new byte[((DynamicSpanField)((Object)layout)).getNoDataSpan()];
            }
            return new byte[layout.getSpan()];
        }
        Object converted = TypeConverterHelper.convertToLayoutType(value, layoutClass);
        return layout.encode(converted);
    }

    @Override
    public <T> List<FieldDebugInfo.Builder> handleDebug(T instance, java.lang.reflect.Field field) throws IllegalAccessException {
        byte[] encodedBytes = this.handleField(instance, field);
        FieldDebugInfo.Builder builder = FieldDebugInfo.builder();
        builder.fieldName(field.getName());
        builder.encodedBytes(encodedBytes);
        return List.of(builder);
    }

    private Field<Object> createLayoutInstance(Class<? extends Field<?>> layoutClass, String fieldName) {
        return this.resolveLayout(layoutClass);
    }
}

