/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.codec.encode.handler;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.deanly.structlayout.analysis.FieldDebugInfo;
import net.deanly.structlayout.annotation.OptionalEncoding;
import net.deanly.structlayout.annotation.StructObjectField;
import net.deanly.structlayout.annotation.StructTypeSelector;
import net.deanly.structlayout.codec.encode.FieldProcessor;
import net.deanly.structlayout.codec.encode.StructEncoder;
import net.deanly.structlayout.codec.encode.handler.BaseFieldHandler;
import net.deanly.structlayout.codec.helpers.CalculateStructureSizeHelper;
import net.deanly.structlayout.dispatcher.StructTypeResolver;

public class StructObjectFieldHandler
extends BaseFieldHandler {
    @Override
    public <T> byte[] handleField(T instance, Field field) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        Object fieldValue = this.extractFieldValue(instance, field);
        StructObjectField annotation = field.getAnnotation(StructObjectField.class);
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Field '%s' is not annotated with @StructObjectField", field.getName()));
        }
        OptionalEncoding opt = annotation.optional();
        if (opt == OptionalEncoding.BORSH) {
            if (fieldValue == null) {
                return new byte[]{0};
            }
            byte[] encoded = StructEncoder.encode(fieldValue);
            byte[] result = new byte[1 + encoded.length];
            result[0] = 1;
            System.arraycopy(encoded, 0, result, 1, encoded.length);
            return result;
        }
        if (fieldValue == null) {
            if (field.getType().getAnnotation(StructTypeSelector.class) != null) {
                int span = StructTypeResolver.resolveNoDataSpan(field.getType());
                return new byte[span];
            }
            int span = CalculateStructureSizeHelper.calculateNoDataClassSize(field.getType());
            return new byte[span];
        }
        return StructEncoder.encode(fieldValue);
    }

    @Override
    public <T> List<FieldDebugInfo.Builder> handleDebug(T instance, Field field) throws IllegalAccessException {
        Object fieldValue = this.extractFieldValue(instance, field);
        StructObjectField annotation = field.getAnnotation(StructObjectField.class);
        OptionalEncoding opt = annotation.optional();
        ArrayList<FieldDebugInfo.Builder> builders = new ArrayList<FieldDebugInfo.Builder>();
        if (opt == OptionalEncoding.BORSH) {
            builders.add(FieldDebugInfo.builder().fieldName(field.getName()).orderSuffix(".optional_tag").encodedBytes(new byte[]{(byte)(fieldValue != null ? 1 : 0)}));
            if (fieldValue == null) {
                return builders;
            }
        }
        if (fieldValue == null) {
            return builders;
        }
        for (Field innerField : fieldValue.getClass().getDeclaredFields()) {
            innerField.setAccessible(true);
            List<FieldDebugInfo> infos = FieldProcessor.processFieldRecursivelyWithDebug(fieldValue, innerField, "");
            for (FieldDebugInfo info : infos) {
                builders.add(FieldDebugInfo.builder().fieldName(info.getFieldName()).orderSuffix(info.getOrderString()).encodedBytes(info.getEncodedBytes()));
            }
        }
        return builders;
    }
}

