/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.codec.encode.handler;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import net.deanly.structlayout.Field;
import net.deanly.structlayout.analysis.FieldDebugInfo;
import net.deanly.structlayout.annotation.OptionalEncoding;
import net.deanly.structlayout.annotation.StructSequenceField;
import net.deanly.structlayout.codec.encode.handler.BaseFieldHandler;
import net.deanly.structlayout.codec.helpers.ByteArrayHelper;
import net.deanly.structlayout.codec.helpers.TypeConverterHelper;
import net.deanly.structlayout.exception.InvalidSequenceTypeException;
import net.deanly.structlayout.exception.LayoutInitializationException;
import net.deanly.structlayout.type.CountableField;
import net.deanly.structlayout.type.advanced.NoneField;

public class StructSequenceFieldHandler
extends BaseFieldHandler {
    @Override
    public <T> byte[] handleField(T instance, java.lang.reflect.Field field) throws IllegalAccessException {
        StructSequenceField annotation = field.getAnnotation(StructSequenceField.class);
        if (annotation == null) {
            throw new InvalidSequenceTypeException(field.getName(), field.getType());
        }
        OptionalEncoding opt = annotation.optional();
        Object arrayOrList = this.extractFieldValue(instance, field);
        Class<? extends CountableField<?>> lengthType = annotation.lengthType();
        Class<? extends Field<?>> elementFieldType = annotation.elementType();
        boolean unsafeMode = NoneField.class.isAssignableFrom(lengthType);
        if (opt == OptionalEncoding.BORSH) {
            if (arrayOrList == null) {
                return new byte[]{0};
            }
            List<Object> elements = this.toElementList(arrayOrList);
            byte[] encoded = this.encodeLengthAndElements(elements, lengthType, elementFieldType, unsafeMode);
            byte[] result = new byte[1 + encoded.length];
            result[0] = 1;
            System.arraycopy(encoded, 0, result, 1, encoded.length);
            return result;
        }
        if (arrayOrList == null) {
            return this.encodeLengthAndElements(new ArrayList<Object>(), lengthType, elementFieldType, unsafeMode);
        }
        List<Object> elements = this.toElementList(arrayOrList);
        return this.encodeLengthAndElements(elements, lengthType, elementFieldType, unsafeMode);
    }

    private List<Object> toElementList(Object arrayOrList) {
        ArrayList<Object> elements = new ArrayList<Object>();
        if (arrayOrList.getClass().isArray()) {
            int arrayLength = Array.getLength(arrayOrList);
            for (int i = 0; i < arrayLength; ++i) {
                elements.add(Array.get(arrayOrList, i));
            }
        } else if (arrayOrList instanceof Iterable) {
            for (Object element : (Iterable)arrayOrList) {
                elements.add(element);
            }
        } else {
            throw new InvalidSequenceTypeException("Unsupported field type", arrayOrList.getClass());
        }
        return elements;
    }

    private byte[] encodeLengthAndElements(List<Object> elements, Class<? extends CountableField<?>> lengthType, Class<? extends Field<?>> elementFieldType, boolean unsafeMode) {
        ArrayList<byte[]> encodedChunks = new ArrayList<byte[]>();
        try {
            if (!unsafeMode) {
                Object convertedLength = TypeConverterHelper.convertToLayoutType(elements.size(), lengthType);
                encodedChunks.add(this.encodeElement(lengthType, convertedLength));
            }
            for (Object e : elements) {
                Object convertedElement = TypeConverterHelper.convertToLayoutType(e, elementFieldType);
                encodedChunks.add(this.encodeElement(elementFieldType, convertedElement));
            }
        }
        catch (Exception e) {
            throw new LayoutInitializationException("Failed to initialize layout for element or length type. Ensure that Field class is correctly defined.", e);
        }
        return ByteArrayHelper.mergeChunks(encodedChunks);
    }

    @Override
    public <T> List<FieldDebugInfo.Builder> handleDebug(T instance, java.lang.reflect.Field field) throws IllegalAccessException {
        List<Object> elements;
        StructSequenceField annotation = field.getAnnotation(StructSequenceField.class);
        if (annotation == null) {
            throw new InvalidSequenceTypeException(field.getName(), field.getType());
        }
        OptionalEncoding opt = annotation.optional();
        Class<? extends CountableField<?>> lengthType = annotation.lengthType();
        Class<? extends Field<?>> elementFieldType = annotation.elementType();
        boolean unsafeMode = NoneField.class.isAssignableFrom(lengthType);
        Object arrayOrList = this.extractFieldValue(instance, field);
        ArrayList<FieldDebugInfo.Builder> builders = new ArrayList<FieldDebugInfo.Builder>();
        if (opt == OptionalEncoding.BORSH) {
            builders.add(FieldDebugInfo.builder().fieldName(field.getName()).orderSuffix("[].optional_tag").encodedBytes(new byte[]{arrayOrList == null ? (byte)0 : 1}));
            if (arrayOrList == null) {
                return builders;
            }
        }
        List<Object> list = elements = arrayOrList == null ? new ArrayList() : this.toElementList(arrayOrList);
        if (!unsafeMode) {
            Object convertedLength = TypeConverterHelper.convertToLayoutType(elements.size(), lengthType);
            byte[] encodedLength = this.encodeElement(lengthType, convertedLength);
            builders.add(FieldDebugInfo.builder().fieldName(field.getName()).orderSuffix("[].length").encodedBytes(encodedLength));
        }
        for (int i = 0; i < elements.size(); ++i) {
            Object converted = TypeConverterHelper.convertToLayoutType(elements.get(i), elementFieldType);
            byte[] encoded = this.encodeElement(elementFieldType, converted);
            builders.add(FieldDebugInfo.builder().fieldName(field.getName()).orderSuffix("[" + i + "]").encodedBytes(encoded));
        }
        return builders;
    }
}

