/*
 * Decompiled with CFR 0.152.
 */
package net.deanly.structlayout.codec.helpers;

import java.util.List;

public class ByteArrayHelper {
    public static byte[] mergeChunks(List<byte[]> chunks) {
        int totalLength = chunks.stream().mapToInt(chunk -> ((byte[])chunk).length).sum();
        byte[] merged = new byte[totalLength];
        int offset = 0;
        for (byte[] chunk2 : chunks) {
            System.arraycopy(chunk2, 0, merged, offset, chunk2.length);
            offset += chunk2.length;
        }
        return merged;
    }

    public static byte[] mergeChunks(byte[] ... chunks) {
        int totalLength = 0;
        for (byte[] chunk : chunks) {
            totalLength += chunk.length;
        }
        byte[] merged = new byte[totalLength];
        int offset = 0;
        for (byte[] chunk : chunks) {
            System.arraycopy(chunk, 0, merged, offset, chunk.length);
            offset += chunk.length;
        }
        return merged;
    }

    public static byte[] extractSubArray(byte[] data, int offset, int length) {
        if (data == null || offset < 0 || length < 0 || offset + length > data.length) {
            throw new IllegalArgumentException("Invalid offset or length.");
        }
        if (length == 0) {
            return new byte[0];
        }
        byte[] result = new byte[length];
        System.arraycopy(data, offset, result, 0, length);
        return result;
    }
}

